/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.Operation;
import com.amazonaws.services.lightsail.model.transform.ResourceLocationJsonMarshaller;

public class OperationJsonMarshaller {
    private static OperationJsonMarshaller instance;

    public void marshall(Operation operation, StructuredJsonGenerator jsonGenerator) {
        if (operation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (operation.getId() != null) {
                jsonGenerator.writeFieldName("id").writeValue(operation.getId());
            }
            if (operation.getResourceName() != null) {
                jsonGenerator.writeFieldName("resourceName").writeValue(operation.getResourceName());
            }
            if (operation.getResourceType() != null) {
                jsonGenerator.writeFieldName("resourceType").writeValue(operation.getResourceType());
            }
            if (operation.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("createdAt").writeValue(operation.getCreatedAt());
            }
            if (operation.getLocation() != null) {
                jsonGenerator.writeFieldName("location");
                ResourceLocationJsonMarshaller.getInstance().marshall(operation.getLocation(), jsonGenerator);
            }
            if (operation.getIsTerminal() != null) {
                jsonGenerator.writeFieldName("isTerminal").writeValue(operation.getIsTerminal().booleanValue());
            }
            if (operation.getOperationDetails() != null) {
                jsonGenerator.writeFieldName("operationDetails").writeValue(operation.getOperationDetails());
            }
            if (operation.getOperationType() != null) {
                jsonGenerator.writeFieldName("operationType").writeValue(operation.getOperationType());
            }
            if (operation.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(operation.getStatus());
            }
            if (operation.getStatusChangedAt() != null) {
                jsonGenerator.writeFieldName("statusChangedAt").writeValue(operation.getStatusChangedAt());
            }
            if (operation.getErrorCode() != null) {
                jsonGenerator.writeFieldName("errorCode").writeValue(operation.getErrorCode());
            }
            if (operation.getErrorDetails() != null) {
                jsonGenerator.writeFieldName("errorDetails").writeValue(operation.getErrorDetails());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static OperationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new OperationJsonMarshaller();
        }
        return instance;
    }
}

