/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.CacheSettings;

@SdkInternalApi
public class CacheSettingsMarshaller {
    private static final MarshallingInfo<Long> DEFAULTTTL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultTTL").build();
    private static final MarshallingInfo<Long> MINIMUMTTL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minimumTTL").build();
    private static final MarshallingInfo<Long> MAXIMUMTTL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maximumTTL").build();
    private static final MarshallingInfo<String> ALLOWEDHTTPMETHODS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowedHTTPMethods").build();
    private static final MarshallingInfo<String> CACHEDHTTPMETHODS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cachedHTTPMethods").build();
    private static final MarshallingInfo<StructuredPojo> FORWARDEDCOOKIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("forwardedCookies").build();
    private static final MarshallingInfo<StructuredPojo> FORWARDEDHEADERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("forwardedHeaders").build();
    private static final MarshallingInfo<StructuredPojo> FORWARDEDQUERYSTRINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("forwardedQueryStrings").build();
    private static final CacheSettingsMarshaller instance = new CacheSettingsMarshaller();

    public static CacheSettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(CacheSettings cacheSettings, ProtocolMarshaller protocolMarshaller) {
        if (cacheSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cacheSettings.getDefaultTTL(), DEFAULTTTL_BINDING);
            protocolMarshaller.marshall((Object)cacheSettings.getMinimumTTL(), MINIMUMTTL_BINDING);
            protocolMarshaller.marshall((Object)cacheSettings.getMaximumTTL(), MAXIMUMTTL_BINDING);
            protocolMarshaller.marshall((Object)cacheSettings.getAllowedHTTPMethods(), ALLOWEDHTTPMETHODS_BINDING);
            protocolMarshaller.marshall((Object)cacheSettings.getCachedHTTPMethods(), CACHEDHTTPMETHODS_BINDING);
            protocolMarshaller.marshall((Object)cacheSettings.getForwardedCookies(), FORWARDEDCOOKIES_BINDING);
            protocolMarshaller.marshall((Object)cacheSettings.getForwardedHeaders(), FORWARDEDHEADERS_BINDING);
            protocolMarshaller.marshall((Object)cacheSettings.getForwardedQueryStrings(), FORWARDEDQUERYSTRINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

