/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.AccessibilityType;
import com.amazonaws.services.medialive.model.CaptionDestinationSettings;
import com.amazonaws.services.medialive.model.DashRoleCaption;
import com.amazonaws.services.medialive.model.DvbDashAccessibility;
import com.amazonaws.services.medialive.model.transform.CaptionDescriptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CaptionDescription
implements Serializable,
Cloneable,
StructuredPojo {
    private String accessibility;
    private String captionSelectorName;
    private CaptionDestinationSettings destinationSettings;
    private String languageCode;
    private String languageDescription;
    private String name;
    private List<String> captionDashRoles;
    private String dvbDashAccessibility;

    public void setAccessibility(String accessibility) {
        this.accessibility = accessibility;
    }

    public String getAccessibility() {
        return this.accessibility;
    }

    public CaptionDescription withAccessibility(String accessibility) {
        this.setAccessibility(accessibility);
        return this;
    }

    public CaptionDescription withAccessibility(AccessibilityType accessibility) {
        this.accessibility = accessibility.toString();
        return this;
    }

    public void setCaptionSelectorName(String captionSelectorName) {
        this.captionSelectorName = captionSelectorName;
    }

    public String getCaptionSelectorName() {
        return this.captionSelectorName;
    }

    public CaptionDescription withCaptionSelectorName(String captionSelectorName) {
        this.setCaptionSelectorName(captionSelectorName);
        return this;
    }

    public void setDestinationSettings(CaptionDestinationSettings destinationSettings) {
        this.destinationSettings = destinationSettings;
    }

    public CaptionDestinationSettings getDestinationSettings() {
        return this.destinationSettings;
    }

    public CaptionDescription withDestinationSettings(CaptionDestinationSettings destinationSettings) {
        this.setDestinationSettings(destinationSettings);
        return this;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public CaptionDescription withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public void setLanguageDescription(String languageDescription) {
        this.languageDescription = languageDescription;
    }

    public String getLanguageDescription() {
        return this.languageDescription;
    }

    public CaptionDescription withLanguageDescription(String languageDescription) {
        this.setLanguageDescription(languageDescription);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CaptionDescription withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getCaptionDashRoles() {
        return this.captionDashRoles;
    }

    public void setCaptionDashRoles(Collection<String> captionDashRoles) {
        if (captionDashRoles == null) {
            this.captionDashRoles = null;
            return;
        }
        this.captionDashRoles = new ArrayList<String>(captionDashRoles);
    }

    public CaptionDescription withCaptionDashRoles(String ... captionDashRoles) {
        if (this.captionDashRoles == null) {
            this.setCaptionDashRoles(new ArrayList<String>(captionDashRoles.length));
        }
        for (String ele : captionDashRoles) {
            this.captionDashRoles.add(ele);
        }
        return this;
    }

    public CaptionDescription withCaptionDashRoles(Collection<String> captionDashRoles) {
        this.setCaptionDashRoles(captionDashRoles);
        return this;
    }

    public CaptionDescription withCaptionDashRoles(DashRoleCaption ... captionDashRoles) {
        ArrayList<String> captionDashRolesCopy = new ArrayList<String>(captionDashRoles.length);
        for (DashRoleCaption value : captionDashRoles) {
            captionDashRolesCopy.add(value.toString());
        }
        if (this.getCaptionDashRoles() == null) {
            this.setCaptionDashRoles(captionDashRolesCopy);
        } else {
            this.getCaptionDashRoles().addAll(captionDashRolesCopy);
        }
        return this;
    }

    public void setDvbDashAccessibility(String dvbDashAccessibility) {
        this.dvbDashAccessibility = dvbDashAccessibility;
    }

    public String getDvbDashAccessibility() {
        return this.dvbDashAccessibility;
    }

    public CaptionDescription withDvbDashAccessibility(String dvbDashAccessibility) {
        this.setDvbDashAccessibility(dvbDashAccessibility);
        return this;
    }

    public CaptionDescription withDvbDashAccessibility(DvbDashAccessibility dvbDashAccessibility) {
        this.dvbDashAccessibility = dvbDashAccessibility.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccessibility() != null) {
            sb.append("Accessibility: ").append(this.getAccessibility()).append(",");
        }
        if (this.getCaptionSelectorName() != null) {
            sb.append("CaptionSelectorName: ").append(this.getCaptionSelectorName()).append(",");
        }
        if (this.getDestinationSettings() != null) {
            sb.append("DestinationSettings: ").append(this.getDestinationSettings()).append(",");
        }
        if (this.getLanguageCode() != null) {
            sb.append("LanguageCode: ").append(this.getLanguageCode()).append(",");
        }
        if (this.getLanguageDescription() != null) {
            sb.append("LanguageDescription: ").append(this.getLanguageDescription()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getCaptionDashRoles() != null) {
            sb.append("CaptionDashRoles: ").append(this.getCaptionDashRoles()).append(",");
        }
        if (this.getDvbDashAccessibility() != null) {
            sb.append("DvbDashAccessibility: ").append(this.getDvbDashAccessibility());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionDescription)) {
            return false;
        }
        CaptionDescription other = (CaptionDescription)obj;
        if (other.getAccessibility() == null ^ this.getAccessibility() == null) {
            return false;
        }
        if (other.getAccessibility() != null && !other.getAccessibility().equals(this.getAccessibility())) {
            return false;
        }
        if (other.getCaptionSelectorName() == null ^ this.getCaptionSelectorName() == null) {
            return false;
        }
        if (other.getCaptionSelectorName() != null && !other.getCaptionSelectorName().equals(this.getCaptionSelectorName())) {
            return false;
        }
        if (other.getDestinationSettings() == null ^ this.getDestinationSettings() == null) {
            return false;
        }
        if (other.getDestinationSettings() != null && !other.getDestinationSettings().equals(this.getDestinationSettings())) {
            return false;
        }
        if (other.getLanguageCode() == null ^ this.getLanguageCode() == null) {
            return false;
        }
        if (other.getLanguageCode() != null && !other.getLanguageCode().equals(this.getLanguageCode())) {
            return false;
        }
        if (other.getLanguageDescription() == null ^ this.getLanguageDescription() == null) {
            return false;
        }
        if (other.getLanguageDescription() != null && !other.getLanguageDescription().equals(this.getLanguageDescription())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getCaptionDashRoles() == null ^ this.getCaptionDashRoles() == null) {
            return false;
        }
        if (other.getCaptionDashRoles() != null && !other.getCaptionDashRoles().equals(this.getCaptionDashRoles())) {
            return false;
        }
        if (other.getDvbDashAccessibility() == null ^ this.getDvbDashAccessibility() == null) {
            return false;
        }
        return other.getDvbDashAccessibility() == null || other.getDvbDashAccessibility().equals(this.getDvbDashAccessibility());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccessibility() == null ? 0 : this.getAccessibility().hashCode());
        hashCode = 31 * hashCode + (this.getCaptionSelectorName() == null ? 0 : this.getCaptionSelectorName().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationSettings() == null ? 0 : this.getDestinationSettings().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageCode() == null ? 0 : this.getLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageDescription() == null ? 0 : this.getLanguageDescription().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getCaptionDashRoles() == null ? 0 : this.getCaptionDashRoles().hashCode());
        hashCode = 31 * hashCode + (this.getDvbDashAccessibility() == null ? 0 : this.getDvbDashAccessibility().hashCode());
        return hashCode;
    }

    public CaptionDescription clone() {
        try {
            return (CaptionDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CaptionDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

