/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.ColorCorrection;
import com.amazonaws.services.medialive.model.transform.ColorCorrectionSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ColorCorrectionSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ColorCorrection> globalColorCorrections;

    public List<ColorCorrection> getGlobalColorCorrections() {
        return this.globalColorCorrections;
    }

    public void setGlobalColorCorrections(Collection<ColorCorrection> globalColorCorrections) {
        if (globalColorCorrections == null) {
            this.globalColorCorrections = null;
            return;
        }
        this.globalColorCorrections = new ArrayList<ColorCorrection>(globalColorCorrections);
    }

    public ColorCorrectionSettings withGlobalColorCorrections(ColorCorrection ... globalColorCorrections) {
        if (this.globalColorCorrections == null) {
            this.setGlobalColorCorrections(new ArrayList<ColorCorrection>(globalColorCorrections.length));
        }
        for (ColorCorrection ele : globalColorCorrections) {
            this.globalColorCorrections.add(ele);
        }
        return this;
    }

    public ColorCorrectionSettings withGlobalColorCorrections(Collection<ColorCorrection> globalColorCorrections) {
        this.setGlobalColorCorrections(globalColorCorrections);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGlobalColorCorrections() != null) {
            sb.append("GlobalColorCorrections: ").append(this.getGlobalColorCorrections());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColorCorrectionSettings)) {
            return false;
        }
        ColorCorrectionSettings other = (ColorCorrectionSettings)obj;
        if (other.getGlobalColorCorrections() == null ^ this.getGlobalColorCorrections() == null) {
            return false;
        }
        return other.getGlobalColorCorrections() == null || other.getGlobalColorCorrections().equals(this.getGlobalColorCorrections());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGlobalColorCorrections() == null ? 0 : this.getGlobalColorCorrections().hashCode());
        return hashCode;
    }

    public ColorCorrectionSettings clone() {
        try {
            return (ColorCorrectionSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ColorCorrectionSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

