/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.medialive.model.ChannelPipelineIdToRestart;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RestartChannelPipelinesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String channelId;
    private List<String> pipelineIds;

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public RestartChannelPipelinesRequest withChannelId(String channelId) {
        this.setChannelId(channelId);
        return this;
    }

    public List<String> getPipelineIds() {
        return this.pipelineIds;
    }

    public void setPipelineIds(Collection<String> pipelineIds) {
        if (pipelineIds == null) {
            this.pipelineIds = null;
            return;
        }
        this.pipelineIds = new ArrayList<String>(pipelineIds);
    }

    public RestartChannelPipelinesRequest withPipelineIds(String ... pipelineIds) {
        if (this.pipelineIds == null) {
            this.setPipelineIds(new ArrayList<String>(pipelineIds.length));
        }
        for (String ele : pipelineIds) {
            this.pipelineIds.add(ele);
        }
        return this;
    }

    public RestartChannelPipelinesRequest withPipelineIds(Collection<String> pipelineIds) {
        this.setPipelineIds(pipelineIds);
        return this;
    }

    public RestartChannelPipelinesRequest withPipelineIds(ChannelPipelineIdToRestart ... pipelineIds) {
        ArrayList<String> pipelineIdsCopy = new ArrayList<String>(pipelineIds.length);
        for (ChannelPipelineIdToRestart value : pipelineIds) {
            pipelineIdsCopy.add(value.toString());
        }
        if (this.getPipelineIds() == null) {
            this.setPipelineIds(pipelineIdsCopy);
        } else {
            this.getPipelineIds().addAll(pipelineIdsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getChannelId() != null) {
            sb.append("ChannelId: ").append(this.getChannelId()).append(",");
        }
        if (this.getPipelineIds() != null) {
            sb.append("PipelineIds: ").append(this.getPipelineIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestartChannelPipelinesRequest)) {
            return false;
        }
        RestartChannelPipelinesRequest other = (RestartChannelPipelinesRequest)obj;
        if (other.getChannelId() == null ^ this.getChannelId() == null) {
            return false;
        }
        if (other.getChannelId() != null && !other.getChannelId().equals(this.getChannelId())) {
            return false;
        }
        if (other.getPipelineIds() == null ^ this.getPipelineIds() == null) {
            return false;
        }
        return other.getPipelineIds() == null || other.getPipelineIds().equals(this.getPipelineIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getChannelId() == null ? 0 : this.getChannelId().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineIds() == null ? 0 : this.getPipelineIds().hashCode());
        return hashCode;
    }

    public RestartChannelPipelinesRequest clone() {
        return (RestartChannelPipelinesRequest)super.clone();
    }
}

