/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediastore;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.mediastore.AWSMediaStore;
import com.amazonaws.services.mediastore.AWSMediaStoreClientBuilder;
import com.amazonaws.services.mediastore.model.AWSMediaStoreException;
import com.amazonaws.services.mediastore.model.CreateContainerRequest;
import com.amazonaws.services.mediastore.model.CreateContainerResult;
import com.amazonaws.services.mediastore.model.DeleteContainerPolicyRequest;
import com.amazonaws.services.mediastore.model.DeleteContainerPolicyResult;
import com.amazonaws.services.mediastore.model.DeleteContainerRequest;
import com.amazonaws.services.mediastore.model.DeleteContainerResult;
import com.amazonaws.services.mediastore.model.DeleteCorsPolicyRequest;
import com.amazonaws.services.mediastore.model.DeleteCorsPolicyResult;
import com.amazonaws.services.mediastore.model.DeleteLifecyclePolicyRequest;
import com.amazonaws.services.mediastore.model.DeleteLifecyclePolicyResult;
import com.amazonaws.services.mediastore.model.DeleteMetricPolicyRequest;
import com.amazonaws.services.mediastore.model.DeleteMetricPolicyResult;
import com.amazonaws.services.mediastore.model.DescribeContainerRequest;
import com.amazonaws.services.mediastore.model.DescribeContainerResult;
import com.amazonaws.services.mediastore.model.GetContainerPolicyRequest;
import com.amazonaws.services.mediastore.model.GetContainerPolicyResult;
import com.amazonaws.services.mediastore.model.GetCorsPolicyRequest;
import com.amazonaws.services.mediastore.model.GetCorsPolicyResult;
import com.amazonaws.services.mediastore.model.GetLifecyclePolicyRequest;
import com.amazonaws.services.mediastore.model.GetLifecyclePolicyResult;
import com.amazonaws.services.mediastore.model.GetMetricPolicyRequest;
import com.amazonaws.services.mediastore.model.GetMetricPolicyResult;
import com.amazonaws.services.mediastore.model.ListContainersRequest;
import com.amazonaws.services.mediastore.model.ListContainersResult;
import com.amazonaws.services.mediastore.model.ListTagsForResourceRequest;
import com.amazonaws.services.mediastore.model.ListTagsForResourceResult;
import com.amazonaws.services.mediastore.model.PutContainerPolicyRequest;
import com.amazonaws.services.mediastore.model.PutContainerPolicyResult;
import com.amazonaws.services.mediastore.model.PutCorsPolicyRequest;
import com.amazonaws.services.mediastore.model.PutCorsPolicyResult;
import com.amazonaws.services.mediastore.model.PutLifecyclePolicyRequest;
import com.amazonaws.services.mediastore.model.PutLifecyclePolicyResult;
import com.amazonaws.services.mediastore.model.PutMetricPolicyRequest;
import com.amazonaws.services.mediastore.model.PutMetricPolicyResult;
import com.amazonaws.services.mediastore.model.StartAccessLoggingRequest;
import com.amazonaws.services.mediastore.model.StartAccessLoggingResult;
import com.amazonaws.services.mediastore.model.StopAccessLoggingRequest;
import com.amazonaws.services.mediastore.model.StopAccessLoggingResult;
import com.amazonaws.services.mediastore.model.TagResourceRequest;
import com.amazonaws.services.mediastore.model.TagResourceResult;
import com.amazonaws.services.mediastore.model.UntagResourceRequest;
import com.amazonaws.services.mediastore.model.UntagResourceResult;
import com.amazonaws.services.mediastore.model.transform.ContainerInUseExceptionUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.ContainerNotFoundExceptionUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.CorsPolicyNotFoundExceptionUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.CreateContainerRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.CreateContainerResultJsonUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.DeleteContainerPolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.DeleteContainerPolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.DeleteContainerRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.DeleteContainerResultJsonUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.DeleteCorsPolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.DeleteCorsPolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.DeleteLifecyclePolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.DeleteLifecyclePolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.DeleteMetricPolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.DeleteMetricPolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.DescribeContainerRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.DescribeContainerResultJsonUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.GetContainerPolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.GetContainerPolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.GetCorsPolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.GetCorsPolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.GetLifecyclePolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.GetLifecyclePolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.GetMetricPolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.GetMetricPolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.ListContainersRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.ListContainersResultJsonUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.PolicyNotFoundExceptionUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.PutContainerPolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.PutContainerPolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.PutCorsPolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.PutCorsPolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.PutLifecyclePolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.PutLifecyclePolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.PutMetricPolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.PutMetricPolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.StartAccessLoggingRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.StartAccessLoggingResultJsonUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.StopAccessLoggingRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.StopAccessLoggingResultJsonUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.mediastore.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.mediastore.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSMediaStoreClient
extends AmazonWebServiceClient
implements AWSMediaStore {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSMediaStore.class);
    private static final String DEFAULT_SIGNING_NAME = "mediastore";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ContainerInUseException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ContainerInUseExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CorsPolicyNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)CorsPolicyNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ContainerNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ContainerNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PolicyNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)PolicyNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerErrorExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSMediaStoreException.class));

    public static AWSMediaStoreClientBuilder builder() {
        return AWSMediaStoreClientBuilder.standard();
    }

    AWSMediaStoreClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSMediaStoreClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("mediastore.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/mediastore/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/mediastore/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateContainerResult createContainer(CreateContainerRequest request) {
        request = (CreateContainerRequest)this.beforeClientExecution(request);
        return this.executeCreateContainer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateContainerResult executeCreateContainer(CreateContainerRequest createContainerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createContainerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateContainerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateContainerRequestProtocolMarshaller(protocolFactory).marshall((CreateContainerRequest)super.beforeMarshalling((AmazonWebServiceRequest)createContainerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateContainer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateContainerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateContainerResult createContainerResult = (CreateContainerResult)response.getAwsResponse();
            return createContainerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteContainerResult deleteContainer(DeleteContainerRequest request) {
        request = (DeleteContainerRequest)this.beforeClientExecution(request);
        return this.executeDeleteContainer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteContainerResult executeDeleteContainer(DeleteContainerRequest deleteContainerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteContainerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteContainerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteContainerRequestProtocolMarshaller(protocolFactory).marshall((DeleteContainerRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteContainerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteContainer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteContainerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteContainerResult deleteContainerResult = (DeleteContainerResult)response.getAwsResponse();
            return deleteContainerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteContainerPolicyResult deleteContainerPolicy(DeleteContainerPolicyRequest request) {
        request = (DeleteContainerPolicyRequest)this.beforeClientExecution(request);
        return this.executeDeleteContainerPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteContainerPolicyResult executeDeleteContainerPolicy(DeleteContainerPolicyRequest deleteContainerPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteContainerPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteContainerPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteContainerPolicyRequestProtocolMarshaller(protocolFactory).marshall((DeleteContainerPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteContainerPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteContainerPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteContainerPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteContainerPolicyResult deleteContainerPolicyResult = (DeleteContainerPolicyResult)response.getAwsResponse();
            return deleteContainerPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteCorsPolicyResult deleteCorsPolicy(DeleteCorsPolicyRequest request) {
        request = (DeleteCorsPolicyRequest)this.beforeClientExecution(request);
        return this.executeDeleteCorsPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteCorsPolicyResult executeDeleteCorsPolicy(DeleteCorsPolicyRequest deleteCorsPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteCorsPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteCorsPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteCorsPolicyRequestProtocolMarshaller(protocolFactory).marshall((DeleteCorsPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteCorsPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteCorsPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteCorsPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteCorsPolicyResult deleteCorsPolicyResult = (DeleteCorsPolicyResult)response.getAwsResponse();
            return deleteCorsPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteLifecyclePolicyResult deleteLifecyclePolicy(DeleteLifecyclePolicyRequest request) {
        request = (DeleteLifecyclePolicyRequest)this.beforeClientExecution(request);
        return this.executeDeleteLifecyclePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteLifecyclePolicyResult executeDeleteLifecyclePolicy(DeleteLifecyclePolicyRequest deleteLifecyclePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteLifecyclePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteLifecyclePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteLifecyclePolicyRequestProtocolMarshaller(protocolFactory).marshall((DeleteLifecyclePolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteLifecyclePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteLifecyclePolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteLifecyclePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteLifecyclePolicyResult deleteLifecyclePolicyResult = (DeleteLifecyclePolicyResult)response.getAwsResponse();
            return deleteLifecyclePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteMetricPolicyResult deleteMetricPolicy(DeleteMetricPolicyRequest request) {
        request = (DeleteMetricPolicyRequest)this.beforeClientExecution(request);
        return this.executeDeleteMetricPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteMetricPolicyResult executeDeleteMetricPolicy(DeleteMetricPolicyRequest deleteMetricPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMetricPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteMetricPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteMetricPolicyRequestProtocolMarshaller(protocolFactory).marshall((DeleteMetricPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteMetricPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteMetricPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteMetricPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteMetricPolicyResult deleteMetricPolicyResult = (DeleteMetricPolicyResult)response.getAwsResponse();
            return deleteMetricPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeContainerResult describeContainer(DescribeContainerRequest request) {
        request = (DescribeContainerRequest)this.beforeClientExecution(request);
        return this.executeDescribeContainer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeContainerResult executeDescribeContainer(DescribeContainerRequest describeContainerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeContainerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeContainerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeContainerRequestProtocolMarshaller(protocolFactory).marshall((DescribeContainerRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeContainerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeContainer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeContainerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeContainerResult describeContainerResult = (DescribeContainerResult)response.getAwsResponse();
            return describeContainerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetContainerPolicyResult getContainerPolicy(GetContainerPolicyRequest request) {
        request = (GetContainerPolicyRequest)this.beforeClientExecution(request);
        return this.executeGetContainerPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetContainerPolicyResult executeGetContainerPolicy(GetContainerPolicyRequest getContainerPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getContainerPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetContainerPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetContainerPolicyRequestProtocolMarshaller(protocolFactory).marshall((GetContainerPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getContainerPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetContainerPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetContainerPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetContainerPolicyResult getContainerPolicyResult = (GetContainerPolicyResult)response.getAwsResponse();
            return getContainerPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetCorsPolicyResult getCorsPolicy(GetCorsPolicyRequest request) {
        request = (GetCorsPolicyRequest)this.beforeClientExecution(request);
        return this.executeGetCorsPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetCorsPolicyResult executeGetCorsPolicy(GetCorsPolicyRequest getCorsPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCorsPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCorsPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCorsPolicyRequestProtocolMarshaller(protocolFactory).marshall((GetCorsPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getCorsPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetCorsPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCorsPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCorsPolicyResult getCorsPolicyResult = (GetCorsPolicyResult)response.getAwsResponse();
            return getCorsPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetLifecyclePolicyResult getLifecyclePolicy(GetLifecyclePolicyRequest request) {
        request = (GetLifecyclePolicyRequest)this.beforeClientExecution(request);
        return this.executeGetLifecyclePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetLifecyclePolicyResult executeGetLifecyclePolicy(GetLifecyclePolicyRequest getLifecyclePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getLifecyclePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetLifecyclePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetLifecyclePolicyRequestProtocolMarshaller(protocolFactory).marshall((GetLifecyclePolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getLifecyclePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetLifecyclePolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetLifecyclePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetLifecyclePolicyResult getLifecyclePolicyResult = (GetLifecyclePolicyResult)response.getAwsResponse();
            return getLifecyclePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMetricPolicyResult getMetricPolicy(GetMetricPolicyRequest request) {
        request = (GetMetricPolicyRequest)this.beforeClientExecution(request);
        return this.executeGetMetricPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMetricPolicyResult executeGetMetricPolicy(GetMetricPolicyRequest getMetricPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMetricPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMetricPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMetricPolicyRequestProtocolMarshaller(protocolFactory).marshall((GetMetricPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getMetricPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetMetricPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMetricPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetMetricPolicyResult getMetricPolicyResult = (GetMetricPolicyResult)response.getAwsResponse();
            return getMetricPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListContainersResult listContainers(ListContainersRequest request) {
        request = (ListContainersRequest)this.beforeClientExecution(request);
        return this.executeListContainers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListContainersResult executeListContainers(ListContainersRequest listContainersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listContainersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListContainersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListContainersRequestProtocolMarshaller(protocolFactory).marshall((ListContainersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listContainersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListContainers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListContainersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListContainersResult listContainersResult = (ListContainersResult)response.getAwsResponse();
            return listContainersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutContainerPolicyResult putContainerPolicy(PutContainerPolicyRequest request) {
        request = (PutContainerPolicyRequest)this.beforeClientExecution(request);
        return this.executePutContainerPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutContainerPolicyResult executePutContainerPolicy(PutContainerPolicyRequest putContainerPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putContainerPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutContainerPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutContainerPolicyRequestProtocolMarshaller(protocolFactory).marshall((PutContainerPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)putContainerPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutContainerPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutContainerPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutContainerPolicyResult putContainerPolicyResult = (PutContainerPolicyResult)response.getAwsResponse();
            return putContainerPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutCorsPolicyResult putCorsPolicy(PutCorsPolicyRequest request) {
        request = (PutCorsPolicyRequest)this.beforeClientExecution(request);
        return this.executePutCorsPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutCorsPolicyResult executePutCorsPolicy(PutCorsPolicyRequest putCorsPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putCorsPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutCorsPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutCorsPolicyRequestProtocolMarshaller(protocolFactory).marshall((PutCorsPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)putCorsPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutCorsPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutCorsPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutCorsPolicyResult putCorsPolicyResult = (PutCorsPolicyResult)response.getAwsResponse();
            return putCorsPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutLifecyclePolicyResult putLifecyclePolicy(PutLifecyclePolicyRequest request) {
        request = (PutLifecyclePolicyRequest)this.beforeClientExecution(request);
        return this.executePutLifecyclePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutLifecyclePolicyResult executePutLifecyclePolicy(PutLifecyclePolicyRequest putLifecyclePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putLifecyclePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutLifecyclePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutLifecyclePolicyRequestProtocolMarshaller(protocolFactory).marshall((PutLifecyclePolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)putLifecyclePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutLifecyclePolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutLifecyclePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutLifecyclePolicyResult putLifecyclePolicyResult = (PutLifecyclePolicyResult)response.getAwsResponse();
            return putLifecyclePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutMetricPolicyResult putMetricPolicy(PutMetricPolicyRequest request) {
        request = (PutMetricPolicyRequest)this.beforeClientExecution(request);
        return this.executePutMetricPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutMetricPolicyResult executePutMetricPolicy(PutMetricPolicyRequest putMetricPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putMetricPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutMetricPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutMetricPolicyRequestProtocolMarshaller(protocolFactory).marshall((PutMetricPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)putMetricPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutMetricPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutMetricPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutMetricPolicyResult putMetricPolicyResult = (PutMetricPolicyResult)response.getAwsResponse();
            return putMetricPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartAccessLoggingResult startAccessLogging(StartAccessLoggingRequest request) {
        request = (StartAccessLoggingRequest)this.beforeClientExecution(request);
        return this.executeStartAccessLogging(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartAccessLoggingResult executeStartAccessLogging(StartAccessLoggingRequest startAccessLoggingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startAccessLoggingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartAccessLoggingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartAccessLoggingRequestProtocolMarshaller(protocolFactory).marshall((StartAccessLoggingRequest)super.beforeMarshalling((AmazonWebServiceRequest)startAccessLoggingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartAccessLogging");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartAccessLoggingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartAccessLoggingResult startAccessLoggingResult = (StartAccessLoggingResult)response.getAwsResponse();
            return startAccessLoggingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopAccessLoggingResult stopAccessLogging(StopAccessLoggingRequest request) {
        request = (StopAccessLoggingRequest)this.beforeClientExecution(request);
        return this.executeStopAccessLogging(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopAccessLoggingResult executeStopAccessLogging(StopAccessLoggingRequest stopAccessLoggingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopAccessLoggingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopAccessLoggingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopAccessLoggingRequestProtocolMarshaller(protocolFactory).marshall((StopAccessLoggingRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopAccessLoggingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopAccessLogging");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopAccessLoggingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopAccessLoggingResult stopAccessLoggingResult = (StopAccessLoggingResult)response.getAwsResponse();
            return stopAccessLoggingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaStore");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

