/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediastore.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediastore.model.ContainerLevelMetrics;
import com.amazonaws.services.mediastore.model.MetricPolicyRule;
import com.amazonaws.services.mediastore.model.transform.MetricPolicyMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MetricPolicy
implements Serializable,
Cloneable,
StructuredPojo {
    private String containerLevelMetrics;
    private List<MetricPolicyRule> metricPolicyRules;

    public void setContainerLevelMetrics(String containerLevelMetrics) {
        this.containerLevelMetrics = containerLevelMetrics;
    }

    public String getContainerLevelMetrics() {
        return this.containerLevelMetrics;
    }

    public MetricPolicy withContainerLevelMetrics(String containerLevelMetrics) {
        this.setContainerLevelMetrics(containerLevelMetrics);
        return this;
    }

    public MetricPolicy withContainerLevelMetrics(ContainerLevelMetrics containerLevelMetrics) {
        this.containerLevelMetrics = containerLevelMetrics.toString();
        return this;
    }

    public List<MetricPolicyRule> getMetricPolicyRules() {
        return this.metricPolicyRules;
    }

    public void setMetricPolicyRules(Collection<MetricPolicyRule> metricPolicyRules) {
        if (metricPolicyRules == null) {
            this.metricPolicyRules = null;
            return;
        }
        this.metricPolicyRules = new ArrayList<MetricPolicyRule>(metricPolicyRules);
    }

    public MetricPolicy withMetricPolicyRules(MetricPolicyRule ... metricPolicyRules) {
        if (this.metricPolicyRules == null) {
            this.setMetricPolicyRules(new ArrayList<MetricPolicyRule>(metricPolicyRules.length));
        }
        for (MetricPolicyRule ele : metricPolicyRules) {
            this.metricPolicyRules.add(ele);
        }
        return this;
    }

    public MetricPolicy withMetricPolicyRules(Collection<MetricPolicyRule> metricPolicyRules) {
        this.setMetricPolicyRules(metricPolicyRules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerLevelMetrics() != null) {
            sb.append("ContainerLevelMetrics: ").append(this.getContainerLevelMetrics()).append(",");
        }
        if (this.getMetricPolicyRules() != null) {
            sb.append("MetricPolicyRules: ").append(this.getMetricPolicyRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricPolicy)) {
            return false;
        }
        MetricPolicy other = (MetricPolicy)obj;
        if (other.getContainerLevelMetrics() == null ^ this.getContainerLevelMetrics() == null) {
            return false;
        }
        if (other.getContainerLevelMetrics() != null && !other.getContainerLevelMetrics().equals(this.getContainerLevelMetrics())) {
            return false;
        }
        if (other.getMetricPolicyRules() == null ^ this.getMetricPolicyRules() == null) {
            return false;
        }
        return other.getMetricPolicyRules() == null || other.getMetricPolicyRules().equals(this.getMetricPolicyRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerLevelMetrics() == null ? 0 : this.getContainerLevelMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getMetricPolicyRules() == null ? 0 : this.getMetricPolicyRules().hashCode());
        return hashCode;
    }

    public MetricPolicy clone() {
        try {
            return (MetricPolicy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricPolicyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

