/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.opensearch.model.UpgradeStatus;
import com.amazonaws.services.opensearch.model.UpgradeStepItem;
import com.amazonaws.services.opensearch.model.transform.UpgradeHistoryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class UpgradeHistory
implements Serializable,
Cloneable,
StructuredPojo {
    private String upgradeName;
    private Date startTimestamp;
    private String upgradeStatus;
    private List<UpgradeStepItem> stepsList;

    public void setUpgradeName(String upgradeName) {
        this.upgradeName = upgradeName;
    }

    public String getUpgradeName() {
        return this.upgradeName;
    }

    public UpgradeHistory withUpgradeName(String upgradeName) {
        this.setUpgradeName(upgradeName);
        return this;
    }

    public void setStartTimestamp(Date startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public UpgradeHistory withStartTimestamp(Date startTimestamp) {
        this.setStartTimestamp(startTimestamp);
        return this;
    }

    public void setUpgradeStatus(String upgradeStatus) {
        this.upgradeStatus = upgradeStatus;
    }

    public String getUpgradeStatus() {
        return this.upgradeStatus;
    }

    public UpgradeHistory withUpgradeStatus(String upgradeStatus) {
        this.setUpgradeStatus(upgradeStatus);
        return this;
    }

    public UpgradeHistory withUpgradeStatus(UpgradeStatus upgradeStatus) {
        this.upgradeStatus = upgradeStatus.toString();
        return this;
    }

    public List<UpgradeStepItem> getStepsList() {
        return this.stepsList;
    }

    public void setStepsList(Collection<UpgradeStepItem> stepsList) {
        if (stepsList == null) {
            this.stepsList = null;
            return;
        }
        this.stepsList = new ArrayList<UpgradeStepItem>(stepsList);
    }

    public UpgradeHistory withStepsList(UpgradeStepItem ... stepsList) {
        if (this.stepsList == null) {
            this.setStepsList(new ArrayList<UpgradeStepItem>(stepsList.length));
        }
        for (UpgradeStepItem ele : stepsList) {
            this.stepsList.add(ele);
        }
        return this;
    }

    public UpgradeHistory withStepsList(Collection<UpgradeStepItem> stepsList) {
        this.setStepsList(stepsList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUpgradeName() != null) {
            sb.append("UpgradeName: ").append(this.getUpgradeName()).append(",");
        }
        if (this.getStartTimestamp() != null) {
            sb.append("StartTimestamp: ").append(this.getStartTimestamp()).append(",");
        }
        if (this.getUpgradeStatus() != null) {
            sb.append("UpgradeStatus: ").append(this.getUpgradeStatus()).append(",");
        }
        if (this.getStepsList() != null) {
            sb.append("StepsList: ").append(this.getStepsList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeHistory)) {
            return false;
        }
        UpgradeHistory other = (UpgradeHistory)obj;
        if (other.getUpgradeName() == null ^ this.getUpgradeName() == null) {
            return false;
        }
        if (other.getUpgradeName() != null && !other.getUpgradeName().equals(this.getUpgradeName())) {
            return false;
        }
        if (other.getStartTimestamp() == null ^ this.getStartTimestamp() == null) {
            return false;
        }
        if (other.getStartTimestamp() != null && !other.getStartTimestamp().equals(this.getStartTimestamp())) {
            return false;
        }
        if (other.getUpgradeStatus() == null ^ this.getUpgradeStatus() == null) {
            return false;
        }
        if (other.getUpgradeStatus() != null && !other.getUpgradeStatus().equals(this.getUpgradeStatus())) {
            return false;
        }
        if (other.getStepsList() == null ^ this.getStepsList() == null) {
            return false;
        }
        return other.getStepsList() == null || other.getStepsList().equals(this.getStepsList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUpgradeName() == null ? 0 : this.getUpgradeName().hashCode());
        hashCode = 31 * hashCode + (this.getStartTimestamp() == null ? 0 : this.getStartTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getUpgradeStatus() == null ? 0 : this.getUpgradeStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStepsList() == null ? 0 : this.getStepsList().hashCode());
        return hashCode;
    }

    public UpgradeHistory clone() {
        try {
            return (UpgradeHistory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UpgradeHistoryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

