/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.opensearch.model.JWTOptionsInput;

@SdkInternalApi
public class JWTOptionsInputMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").build();
    private static final MarshallingInfo<String> SUBJECTKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubjectKey").build();
    private static final MarshallingInfo<String> ROLESKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RolesKey").build();
    private static final MarshallingInfo<String> PUBLICKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PublicKey").build();
    private static final JWTOptionsInputMarshaller instance = new JWTOptionsInputMarshaller();

    public static JWTOptionsInputMarshaller getInstance() {
        return instance;
    }

    public void marshall(JWTOptionsInput jWTOptionsInput, ProtocolMarshaller protocolMarshaller) {
        if (jWTOptionsInput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)jWTOptionsInput.getEnabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)jWTOptionsInput.getSubjectKey(), SUBJECTKEY_BINDING);
            protocolMarshaller.marshall((Object)jWTOptionsInput.getRolesKey(), ROLESKEY_BINDING);
            protocolMarshaller.marshall((Object)jWTOptionsInput.getPublicKey(), PUBLICKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

