/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.panorama.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.panorama.model.JobResourceTags;
import com.amazonaws.services.panorama.model.TemplateType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateNodeFromTemplateJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<JobResourceTags> jobTags;
    private String nodeDescription;
    private String nodeName;
    private String outputPackageName;
    private String outputPackageVersion;
    private Map<String, String> templateParameters;
    private String templateType;

    public List<JobResourceTags> getJobTags() {
        return this.jobTags;
    }

    public void setJobTags(Collection<JobResourceTags> jobTags) {
        if (jobTags == null) {
            this.jobTags = null;
            return;
        }
        this.jobTags = new ArrayList<JobResourceTags>(jobTags);
    }

    public CreateNodeFromTemplateJobRequest withJobTags(JobResourceTags ... jobTags) {
        if (this.jobTags == null) {
            this.setJobTags(new ArrayList<JobResourceTags>(jobTags.length));
        }
        for (JobResourceTags ele : jobTags) {
            this.jobTags.add(ele);
        }
        return this;
    }

    public CreateNodeFromTemplateJobRequest withJobTags(Collection<JobResourceTags> jobTags) {
        this.setJobTags(jobTags);
        return this;
    }

    public void setNodeDescription(String nodeDescription) {
        this.nodeDescription = nodeDescription;
    }

    public String getNodeDescription() {
        return this.nodeDescription;
    }

    public CreateNodeFromTemplateJobRequest withNodeDescription(String nodeDescription) {
        this.setNodeDescription(nodeDescription);
        return this;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public CreateNodeFromTemplateJobRequest withNodeName(String nodeName) {
        this.setNodeName(nodeName);
        return this;
    }

    public void setOutputPackageName(String outputPackageName) {
        this.outputPackageName = outputPackageName;
    }

    public String getOutputPackageName() {
        return this.outputPackageName;
    }

    public CreateNodeFromTemplateJobRequest withOutputPackageName(String outputPackageName) {
        this.setOutputPackageName(outputPackageName);
        return this;
    }

    public void setOutputPackageVersion(String outputPackageVersion) {
        this.outputPackageVersion = outputPackageVersion;
    }

    public String getOutputPackageVersion() {
        return this.outputPackageVersion;
    }

    public CreateNodeFromTemplateJobRequest withOutputPackageVersion(String outputPackageVersion) {
        this.setOutputPackageVersion(outputPackageVersion);
        return this;
    }

    public Map<String, String> getTemplateParameters() {
        return this.templateParameters;
    }

    public void setTemplateParameters(Map<String, String> templateParameters) {
        this.templateParameters = templateParameters;
    }

    public CreateNodeFromTemplateJobRequest withTemplateParameters(Map<String, String> templateParameters) {
        this.setTemplateParameters(templateParameters);
        return this;
    }

    public CreateNodeFromTemplateJobRequest addTemplateParametersEntry(String key, String value) {
        if (null == this.templateParameters) {
            this.templateParameters = new HashMap<String, String>();
        }
        if (this.templateParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.templateParameters.put(key, value);
        return this;
    }

    public CreateNodeFromTemplateJobRequest clearTemplateParametersEntries() {
        this.templateParameters = null;
        return this;
    }

    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public CreateNodeFromTemplateJobRequest withTemplateType(String templateType) {
        this.setTemplateType(templateType);
        return this;
    }

    public CreateNodeFromTemplateJobRequest withTemplateType(TemplateType templateType) {
        this.templateType = templateType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobTags() != null) {
            sb.append("JobTags: ").append(this.getJobTags()).append(",");
        }
        if (this.getNodeDescription() != null) {
            sb.append("NodeDescription: ").append(this.getNodeDescription()).append(",");
        }
        if (this.getNodeName() != null) {
            sb.append("NodeName: ").append(this.getNodeName()).append(",");
        }
        if (this.getOutputPackageName() != null) {
            sb.append("OutputPackageName: ").append(this.getOutputPackageName()).append(",");
        }
        if (this.getOutputPackageVersion() != null) {
            sb.append("OutputPackageVersion: ").append(this.getOutputPackageVersion()).append(",");
        }
        if (this.getTemplateParameters() != null) {
            sb.append("TemplateParameters: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getTemplateType() != null) {
            sb.append("TemplateType: ").append(this.getTemplateType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNodeFromTemplateJobRequest)) {
            return false;
        }
        CreateNodeFromTemplateJobRequest other = (CreateNodeFromTemplateJobRequest)obj;
        if (other.getJobTags() == null ^ this.getJobTags() == null) {
            return false;
        }
        if (other.getJobTags() != null && !other.getJobTags().equals(this.getJobTags())) {
            return false;
        }
        if (other.getNodeDescription() == null ^ this.getNodeDescription() == null) {
            return false;
        }
        if (other.getNodeDescription() != null && !other.getNodeDescription().equals(this.getNodeDescription())) {
            return false;
        }
        if (other.getNodeName() == null ^ this.getNodeName() == null) {
            return false;
        }
        if (other.getNodeName() != null && !other.getNodeName().equals(this.getNodeName())) {
            return false;
        }
        if (other.getOutputPackageName() == null ^ this.getOutputPackageName() == null) {
            return false;
        }
        if (other.getOutputPackageName() != null && !other.getOutputPackageName().equals(this.getOutputPackageName())) {
            return false;
        }
        if (other.getOutputPackageVersion() == null ^ this.getOutputPackageVersion() == null) {
            return false;
        }
        if (other.getOutputPackageVersion() != null && !other.getOutputPackageVersion().equals(this.getOutputPackageVersion())) {
            return false;
        }
        if (other.getTemplateParameters() == null ^ this.getTemplateParameters() == null) {
            return false;
        }
        if (other.getTemplateParameters() != null && !other.getTemplateParameters().equals(this.getTemplateParameters())) {
            return false;
        }
        if (other.getTemplateType() == null ^ this.getTemplateType() == null) {
            return false;
        }
        return other.getTemplateType() == null || other.getTemplateType().equals(this.getTemplateType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobTags() == null ? 0 : this.getJobTags().hashCode());
        hashCode = 31 * hashCode + (this.getNodeDescription() == null ? 0 : this.getNodeDescription().hashCode());
        hashCode = 31 * hashCode + (this.getNodeName() == null ? 0 : this.getNodeName().hashCode());
        hashCode = 31 * hashCode + (this.getOutputPackageName() == null ? 0 : this.getOutputPackageName().hashCode());
        hashCode = 31 * hashCode + (this.getOutputPackageVersion() == null ? 0 : this.getOutputPackageVersion().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateParameters() == null ? 0 : this.getTemplateParameters().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateType() == null ? 0 : this.getTemplateType().hashCode());
        return hashCode;
    }

    public CreateNodeFromTemplateJobRequest clone() {
        return (CreateNodeFromTemplateJobRequest)super.clone();
    }
}

