/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class IPRange
implements Serializable,
Cloneable {
    private String status;
    private String cIDRIP;
    private SdkInternalList<Tag> tags;

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public IPRange withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setCIDRIP(String cIDRIP) {
        this.cIDRIP = cIDRIP;
    }

    public String getCIDRIP() {
        return this.cIDRIP;
    }

    public IPRange withCIDRIP(String cIDRIP) {
        this.setCIDRIP(cIDRIP);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public IPRange withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public IPRange withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getCIDRIP() != null) {
            sb.append("CIDRIP: " + this.getCIDRIP() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPRange)) {
            return false;
        }
        IPRange other = (IPRange)obj;
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getCIDRIP() == null ^ this.getCIDRIP() == null) {
            return false;
        }
        if (other.getCIDRIP() != null && !other.getCIDRIP().equals(this.getCIDRIP())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCIDRIP() == null ? 0 : this.getCIDRIP().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public IPRange clone() {
        try {
            return (IPRange)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

