/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.robomaker.model.WorldFailure;
import com.amazonaws.services.robomaker.model.transform.FailureSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FailureSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer totalFailureCount;
    private List<WorldFailure> failures;

    public void setTotalFailureCount(Integer totalFailureCount) {
        this.totalFailureCount = totalFailureCount;
    }

    public Integer getTotalFailureCount() {
        return this.totalFailureCount;
    }

    public FailureSummary withTotalFailureCount(Integer totalFailureCount) {
        this.setTotalFailureCount(totalFailureCount);
        return this;
    }

    public List<WorldFailure> getFailures() {
        return this.failures;
    }

    public void setFailures(Collection<WorldFailure> failures) {
        if (failures == null) {
            this.failures = null;
            return;
        }
        this.failures = new ArrayList<WorldFailure>(failures);
    }

    public FailureSummary withFailures(WorldFailure ... failures) {
        if (this.failures == null) {
            this.setFailures(new ArrayList<WorldFailure>(failures.length));
        }
        for (WorldFailure ele : failures) {
            this.failures.add(ele);
        }
        return this;
    }

    public FailureSummary withFailures(Collection<WorldFailure> failures) {
        this.setFailures(failures);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTotalFailureCount() != null) {
            sb.append("TotalFailureCount: ").append(this.getTotalFailureCount()).append(",");
        }
        if (this.getFailures() != null) {
            sb.append("Failures: ").append(this.getFailures());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailureSummary)) {
            return false;
        }
        FailureSummary other = (FailureSummary)obj;
        if (other.getTotalFailureCount() == null ^ this.getTotalFailureCount() == null) {
            return false;
        }
        if (other.getTotalFailureCount() != null && !other.getTotalFailureCount().equals(this.getTotalFailureCount())) {
            return false;
        }
        if (other.getFailures() == null ^ this.getFailures() == null) {
            return false;
        }
        return other.getFailures() == null || other.getFailures().equals(this.getFailures());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTotalFailureCount() == null ? 0 : this.getTotalFailureCount().hashCode());
        hashCode = 31 * hashCode + (this.getFailures() == null ? 0 : this.getFailures().hashCode());
        return hashCode;
    }

    public FailureSummary clone() {
        try {
            return (FailureSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FailureSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

