/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.robomaker.model.Robot;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListRobotsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Robot> robots;
    private String nextToken;

    public List<Robot> getRobots() {
        return this.robots;
    }

    public void setRobots(Collection<Robot> robots) {
        if (robots == null) {
            this.robots = null;
            return;
        }
        this.robots = new ArrayList<Robot>(robots);
    }

    public ListRobotsResult withRobots(Robot ... robots) {
        if (this.robots == null) {
            this.setRobots(new ArrayList<Robot>(robots.length));
        }
        for (Robot ele : robots) {
            this.robots.add(ele);
        }
        return this;
    }

    public ListRobotsResult withRobots(Collection<Robot> robots) {
        this.setRobots(robots);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListRobotsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRobots() != null) {
            sb.append("Robots: ").append(this.getRobots()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRobotsResult)) {
            return false;
        }
        ListRobotsResult other = (ListRobotsResult)obj;
        if (other.getRobots() == null ^ this.getRobots() == null) {
            return false;
        }
        if (other.getRobots() != null && !other.getRobots().equals(this.getRobots())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRobots() == null ? 0 : this.getRobots().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListRobotsResult clone() {
        try {
            return (ListRobotsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

