/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.robomaker.model.S3KeyOutput;

@SdkInternalApi
public class S3KeyOutputMarshaller {
    private static final MarshallingInfo<String> S3KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Key").build();
    private static final MarshallingInfo<String> ETAG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("etag").build();
    private static final S3KeyOutputMarshaller instance = new S3KeyOutputMarshaller();

    public static S3KeyOutputMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3KeyOutput s3KeyOutput, ProtocolMarshaller protocolMarshaller) {
        if (s3KeyOutput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3KeyOutput.getS3Key(), S3KEY_BINDING);
            protocolMarshaller.marshall((Object)s3KeyOutput.getEtag(), ETAG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

