/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.robomaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.robomaker.model.Architecture;
import com.amazonaws.services.robomaker.model.transform.SourceConfigMarshaller;
import java.io.Serializable;

public class SourceConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String s3Bucket;
    private String s3Key;
    private String architecture;

    public void setS3Bucket(String s3Bucket) {
        this.s3Bucket = s3Bucket;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public SourceConfig withS3Bucket(String s3Bucket) {
        this.setS3Bucket(s3Bucket);
        return this;
    }

    public void setS3Key(String s3Key) {
        this.s3Key = s3Key;
    }

    public String getS3Key() {
        return this.s3Key;
    }

    public SourceConfig withS3Key(String s3Key) {
        this.setS3Key(s3Key);
        return this;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public SourceConfig withArchitecture(String architecture) {
        this.setArchitecture(architecture);
        return this;
    }

    public SourceConfig withArchitecture(Architecture architecture) {
        this.architecture = architecture.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3Bucket() != null) {
            sb.append("S3Bucket: ").append(this.getS3Bucket()).append(",");
        }
        if (this.getS3Key() != null) {
            sb.append("S3Key: ").append(this.getS3Key()).append(",");
        }
        if (this.getArchitecture() != null) {
            sb.append("Architecture: ").append(this.getArchitecture());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceConfig)) {
            return false;
        }
        SourceConfig other = (SourceConfig)obj;
        if (other.getS3Bucket() == null ^ this.getS3Bucket() == null) {
            return false;
        }
        if (other.getS3Bucket() != null && !other.getS3Bucket().equals(this.getS3Bucket())) {
            return false;
        }
        if (other.getS3Key() == null ^ this.getS3Key() == null) {
            return false;
        }
        if (other.getS3Key() != null && !other.getS3Key().equals(this.getS3Key())) {
            return false;
        }
        if (other.getArchitecture() == null ^ this.getArchitecture() == null) {
            return false;
        }
        return other.getArchitecture() == null || other.getArchitecture().equals(this.getArchitecture());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3Bucket() == null ? 0 : this.getS3Bucket().hashCode());
        hashCode = 31 * hashCode + (this.getS3Key() == null ? 0 : this.getS3Key().hashCode());
        hashCode = 31 * hashCode + (this.getArchitecture() == null ? 0 : this.getArchitecture().hashCode());
        return hashCode;
    }

    public SourceConfig clone() {
        try {
            return (SourceConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

