/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleemail.model.ListIdentitiesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListIdentitiesRequestMarshaller
implements Marshaller<Request<ListIdentitiesRequest>, ListIdentitiesRequest> {
    public Request<ListIdentitiesRequest> marshall(ListIdentitiesRequest listIdentitiesRequest) {
        if (listIdentitiesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listIdentitiesRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "ListIdentities");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (listIdentitiesRequest.getIdentityType() != null) {
            request.addParameter("IdentityType", StringUtils.fromString((String)listIdentitiesRequest.getIdentityType()));
        }
        if (listIdentitiesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listIdentitiesRequest.getNextToken()));
        }
        if (listIdentitiesRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)listIdentitiesRequest.getMaxItems()));
        }
        return request;
    }
}

