/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.sns.model.Topic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListTopicsResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<Topic> topics;
    private String nextToken;

    public List<Topic> getTopics() {
        if (this.topics == null) {
            this.topics = new ListWithAutoConstructFlag();
            this.topics.setAutoConstruct(true);
        }
        return this.topics;
    }

    public void setTopics(Collection<Topic> topics) {
        if (topics == null) {
            this.topics = null;
            return;
        }
        ListWithAutoConstructFlag topicsCopy = new ListWithAutoConstructFlag(topics.size());
        topicsCopy.addAll(topics);
        this.topics = topicsCopy;
    }

    public ListTopicsResult withTopics(Topic ... topics) {
        if (this.getTopics() == null) {
            this.setTopics(new ArrayList<Topic>(topics.length));
        }
        for (Topic value : topics) {
            this.getTopics().add(value);
        }
        return this;
    }

    public ListTopicsResult withTopics(Collection<Topic> topics) {
        if (topics == null) {
            this.topics = null;
        } else {
            ListWithAutoConstructFlag topicsCopy = new ListWithAutoConstructFlag(topics.size());
            topicsCopy.addAll(topics);
            this.topics = topicsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListTopicsResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTopics() != null) {
            sb.append("Topics: " + this.getTopics() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTopics() == null ? 0 : this.getTopics().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicsResult)) {
            return false;
        }
        ListTopicsResult other = (ListTopicsResult)obj;
        if (other.getTopics() == null ^ this.getTopics() == null) {
            return false;
        }
        if (other.getTopics() != null && !other.getTopics().equals(this.getTopics())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public ListTopicsResult clone() {
        try {
            return (ListTopicsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

