/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.transfer.model.ProfileType;
import com.amazonaws.services.transfer.model.Tag;
import com.amazonaws.services.transfer.model.transform.DescribedProfileMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribedProfile
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String profileId;
    private String profileType;
    private String as2Id;
    private List<String> certificateIds;
    private List<Tag> tags;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public DescribedProfile withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public DescribedProfile withProfileId(String profileId) {
        this.setProfileId(profileId);
        return this;
    }

    public void setProfileType(String profileType) {
        this.profileType = profileType;
    }

    public String getProfileType() {
        return this.profileType;
    }

    public DescribedProfile withProfileType(String profileType) {
        this.setProfileType(profileType);
        return this;
    }

    public DescribedProfile withProfileType(ProfileType profileType) {
        this.profileType = profileType.toString();
        return this;
    }

    public void setAs2Id(String as2Id) {
        this.as2Id = as2Id;
    }

    public String getAs2Id() {
        return this.as2Id;
    }

    public DescribedProfile withAs2Id(String as2Id) {
        this.setAs2Id(as2Id);
        return this;
    }

    public List<String> getCertificateIds() {
        return this.certificateIds;
    }

    public void setCertificateIds(Collection<String> certificateIds) {
        if (certificateIds == null) {
            this.certificateIds = null;
            return;
        }
        this.certificateIds = new ArrayList<String>(certificateIds);
    }

    public DescribedProfile withCertificateIds(String ... certificateIds) {
        if (this.certificateIds == null) {
            this.setCertificateIds(new ArrayList<String>(certificateIds.length));
        }
        for (String ele : certificateIds) {
            this.certificateIds.add(ele);
        }
        return this;
    }

    public DescribedProfile withCertificateIds(Collection<String> certificateIds) {
        this.setCertificateIds(certificateIds);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public DescribedProfile withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public DescribedProfile withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getProfileId() != null) {
            sb.append("ProfileId: ").append(this.getProfileId()).append(",");
        }
        if (this.getProfileType() != null) {
            sb.append("ProfileType: ").append(this.getProfileType()).append(",");
        }
        if (this.getAs2Id() != null) {
            sb.append("As2Id: ").append(this.getAs2Id()).append(",");
        }
        if (this.getCertificateIds() != null) {
            sb.append("CertificateIds: ").append(this.getCertificateIds()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedProfile)) {
            return false;
        }
        DescribedProfile other = (DescribedProfile)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getProfileId() == null ^ this.getProfileId() == null) {
            return false;
        }
        if (other.getProfileId() != null && !other.getProfileId().equals(this.getProfileId())) {
            return false;
        }
        if (other.getProfileType() == null ^ this.getProfileType() == null) {
            return false;
        }
        if (other.getProfileType() != null && !other.getProfileType().equals(this.getProfileType())) {
            return false;
        }
        if (other.getAs2Id() == null ^ this.getAs2Id() == null) {
            return false;
        }
        if (other.getAs2Id() != null && !other.getAs2Id().equals(this.getAs2Id())) {
            return false;
        }
        if (other.getCertificateIds() == null ^ this.getCertificateIds() == null) {
            return false;
        }
        if (other.getCertificateIds() != null && !other.getCertificateIds().equals(this.getCertificateIds())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getProfileId() == null ? 0 : this.getProfileId().hashCode());
        hashCode = 31 * hashCode + (this.getProfileType() == null ? 0 : this.getProfileType().hashCode());
        hashCode = 31 * hashCode + (this.getAs2Id() == null ? 0 : this.getAs2Id().hashCode());
        hashCode = 31 * hashCode + (this.getCertificateIds() == null ? 0 : this.getCertificateIds().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public DescribedProfile clone() {
        try {
            return (DescribedProfile)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DescribedProfileMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

