/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.vpclattice.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.vpclattice.model.RuleUpdate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchUpdateRuleRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String listenerIdentifier;
    private List<RuleUpdate> rules;
    private String serviceIdentifier;

    public void setListenerIdentifier(String listenerIdentifier) {
        this.listenerIdentifier = listenerIdentifier;
    }

    public String getListenerIdentifier() {
        return this.listenerIdentifier;
    }

    public BatchUpdateRuleRequest withListenerIdentifier(String listenerIdentifier) {
        this.setListenerIdentifier(listenerIdentifier);
        return this;
    }

    public List<RuleUpdate> getRules() {
        return this.rules;
    }

    public void setRules(Collection<RuleUpdate> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<RuleUpdate>(rules);
    }

    public BatchUpdateRuleRequest withRules(RuleUpdate ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<RuleUpdate>(rules.length));
        }
        for (RuleUpdate ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public BatchUpdateRuleRequest withRules(Collection<RuleUpdate> rules) {
        this.setRules(rules);
        return this;
    }

    public void setServiceIdentifier(String serviceIdentifier) {
        this.serviceIdentifier = serviceIdentifier;
    }

    public String getServiceIdentifier() {
        return this.serviceIdentifier;
    }

    public BatchUpdateRuleRequest withServiceIdentifier(String serviceIdentifier) {
        this.setServiceIdentifier(serviceIdentifier);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getListenerIdentifier() != null) {
            sb.append("ListenerIdentifier: ").append(this.getListenerIdentifier()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules()).append(",");
        }
        if (this.getServiceIdentifier() != null) {
            sb.append("ServiceIdentifier: ").append(this.getServiceIdentifier());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateRuleRequest)) {
            return false;
        }
        BatchUpdateRuleRequest other = (BatchUpdateRuleRequest)obj;
        if (other.getListenerIdentifier() == null ^ this.getListenerIdentifier() == null) {
            return false;
        }
        if (other.getListenerIdentifier() != null && !other.getListenerIdentifier().equals(this.getListenerIdentifier())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        if (other.getRules() != null && !other.getRules().equals(this.getRules())) {
            return false;
        }
        if (other.getServiceIdentifier() == null ^ this.getServiceIdentifier() == null) {
            return false;
        }
        return other.getServiceIdentifier() == null || other.getServiceIdentifier().equals(this.getServiceIdentifier());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getListenerIdentifier() == null ? 0 : this.getListenerIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        hashCode = 31 * hashCode + (this.getServiceIdentifier() == null ? 0 : this.getServiceIdentifier().hashCode());
        return hashCode;
    }

    public BatchUpdateRuleRequest clone() {
        return (BatchUpdateRuleRequest)super.clone();
    }
}

