/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.waf.model.IPSetDescriptor;
import com.amazonaws.services.waf.model.waf_regional.transform.IPSetMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IPSet
implements Serializable,
Cloneable,
StructuredPojo {
    private String iPSetId;
    private String name;
    private List<IPSetDescriptor> iPSetDescriptors;

    public void setIPSetId(String iPSetId) {
        this.iPSetId = iPSetId;
    }

    public String getIPSetId() {
        return this.iPSetId;
    }

    public IPSet withIPSetId(String iPSetId) {
        this.setIPSetId(iPSetId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public IPSet withName(String name) {
        this.setName(name);
        return this;
    }

    public List<IPSetDescriptor> getIPSetDescriptors() {
        return this.iPSetDescriptors;
    }

    public void setIPSetDescriptors(Collection<IPSetDescriptor> iPSetDescriptors) {
        if (iPSetDescriptors == null) {
            this.iPSetDescriptors = null;
            return;
        }
        this.iPSetDescriptors = new ArrayList<IPSetDescriptor>(iPSetDescriptors);
    }

    public IPSet withIPSetDescriptors(IPSetDescriptor ... iPSetDescriptors) {
        if (this.iPSetDescriptors == null) {
            this.setIPSetDescriptors(new ArrayList<IPSetDescriptor>(iPSetDescriptors.length));
        }
        for (IPSetDescriptor ele : iPSetDescriptors) {
            this.iPSetDescriptors.add(ele);
        }
        return this;
    }

    public IPSet withIPSetDescriptors(Collection<IPSetDescriptor> iPSetDescriptors) {
        this.setIPSetDescriptors(iPSetDescriptors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIPSetId() != null) {
            sb.append("IPSetId: ").append(this.getIPSetId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getIPSetDescriptors() != null) {
            sb.append("IPSetDescriptors: ").append(this.getIPSetDescriptors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSet)) {
            return false;
        }
        IPSet other = (IPSet)obj;
        if (other.getIPSetId() == null ^ this.getIPSetId() == null) {
            return false;
        }
        if (other.getIPSetId() != null && !other.getIPSetId().equals(this.getIPSetId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getIPSetDescriptors() == null ^ this.getIPSetDescriptors() == null) {
            return false;
        }
        return other.getIPSetDescriptors() == null || other.getIPSetDescriptors().equals(this.getIPSetDescriptors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIPSetId() == null ? 0 : this.getIPSetId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getIPSetDescriptors() == null ? 0 : this.getIPSetDescriptors().hashCode());
        return hashCode;
    }

    public IPSet clone() {
        try {
            return (IPSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IPSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

