/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import java.io.Serializable;
import javax.transaction.xa.Xid;

public class XID
implements Serializable,
Xid {
    private String meAsString_;
    private int formatId_;
    private int branchUsed_ = 0;
    private int globalUsed_ = 0;
    private byte[] branchQualifier_ = new byte[64];
    private byte[] globalTransactionId_ = new byte[64];
    private static final int DEFAULT_FORMAString = 1096044365;

    private XID(String string) {
        this.formatId_ = 1096044365;
        this.branchQualifier_[0] = 0;
        this.branchUsed_ = 1;
        this.globalTransactionId_ = string.toString().getBytes();
        this.globalUsed_ = string.toString().getBytes().length;
    }

    public XID(String string, String string2) {
        this(string);
        this.branchQualifier_ = string2.getBytes();
        this.branchUsed_ = this.branchQualifier_.length;
        if (this.branchQualifier_.length > 64) {
            throw new RuntimeException("Max branch qualifier length exceeded.");
        }
        if (this.globalUsed_ > 64) {
            throw new RuntimeException("Max global tid length exceeded.");
        }
    }

    public XID(Xid xid) {
        this.formatId_ = xid.getFormatId();
        this.globalTransactionId_ = xid.getGlobalTransactionId();
        this.globalUsed_ = xid.getGlobalTransactionId().length;
        this.branchQualifier_ = xid.getBranchQualifier();
        this.branchUsed_ = xid.getBranchQualifier().length;
    }

    public int getFormatId() {
        return this.formatId_;
    }

    public byte[] getBranchQualifier() {
        return this.branchQualifier_;
    }

    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId_;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Xid)) {
            return false;
        }
        Xid xid = (Xid)object;
        String string = new String(xid.getGlobalTransactionId()).intern();
        String string2 = new String(xid.getBranchQualifier()).intern();
        String string3 = new String(this.getGlobalTransactionId()).intern();
        String string4 = new String(this.getBranchQualifier()).intern();
        return string.intern().equals(string3.intern()) && string2.intern().equals(string4.intern());
    }

    public String toString() {
        if (this.meAsString_ == null) {
            this.meAsString_ = new String(this.getGlobalTransactionId()) + new String(this.getBranchQualifier());
        }
        return this.meAsString_;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

