/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa.jca;

import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.XidFactory;
import java.util.Stack;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.xa.XAResource;

public class JcaTransactionalResource
extends XATransactionalResource {
    private ManagedConnectionFactory mcf;
    private ManagedConnection connection;

    public JcaTransactionalResource(String string, ManagedConnectionFactory managedConnectionFactory) {
        super(string);
        this.mcf = managedConnectionFactory;
    }

    public JcaTransactionalResource(String string, ManagedConnectionFactory managedConnectionFactory, XidFactory xidFactory) {
        super(string, xidFactory);
        this.mcf = managedConnectionFactory;
    }

    public boolean usesXAResource(XAResource xAResource) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XAResource refreshXAConnection() throws ResourceException {
        this.printMsg("refreshXAConnection() for resource: " + this.getName(), 2);
        XAResource xAResource = null;
        if (this.connection != null) {
            try {
                this.connection.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.printMsg("about to block for new connection...", 2);
            this.connection = this.mcf.createManagedConnection(null, null);
        }
        catch (javax.resource.ResourceException resourceException) {
            this.connection = null;
        }
        finally {
            this.printMsg("blocking done.", 2);
        }
        try {
            if (this.connection != null) {
                xAResource = this.connection.getXAResource();
            }
        }
        catch (javax.resource.ResourceException resourceException) {
            this.printMsg("error getting XAResource: " + resourceException.getMessage(), 1);
            Stack<javax.resource.ResourceException> stack = new Stack<javax.resource.ResourceException>();
            stack.push(resourceException);
            throw new ResourceException("Error in getting XA resource", stack);
        }
        this.printMsg("refreshXAConnection() done.", 2);
        return xAResource;
    }

    public void close() throws ResourceException {
        super.close();
        try {
            if (this.connection != null) {
                this.connection.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

