/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.icatch.jta.UserTransactionServer;
import com.atomikos.icatch.system.Configuration;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.rmi.PortableRemoteObject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public final class RemoteClientUserTransaction
implements UserTransaction,
Externalizable,
Referenceable {
    static final int DEFAULT_TIMEOUT = 30;
    private transient UserTransactionServer txmgrServer_;
    private transient TransactionManager txmgr_;
    private transient Hashtable threadToTidMap_;
    private int timeout_;
    private String name_;
    private String initialContextFactory_;
    private String providerUrl_;
    private boolean imported_;
    static /* synthetic */ Class class$com$atomikos$icatch$jta$UserTransactionServer;
    static /* synthetic */ Class class$com$atomikos$icatch$jta$RemoteClientUserTransactionFactory;

    public RemoteClientUserTransaction() {
        this.threadToTidMap_ = new Hashtable();
        this.timeout_ = 30;
        this.imported_ = false;
    }

    public RemoteClientUserTransaction(String string, String string2, String string3) {
        this.initialContextFactory_ = string2;
        this.providerUrl_ = string3;
        this.name_ = string;
        this.threadToTidMap_ = new Hashtable();
        this.timeout_ = 30;
        this.imported_ = false;
    }

    private String getNotFoundMessage() {
        String string = "Name not found: " + this.name_ + "\n" + "Please check that: \n" + "\t-server property com.atomikos.icatch.client_demarcation is set to true \n" + "   -server property com.atomikos.icatch.rmi_export_class is correct \n" + "\t-server property java.naming.factory.initial is " + this.initialContextFactory_ + "\n" + "\t-server property java.naming.provider.url is " + this.providerUrl_ + "\n" + "\t-the naming service is running on port " + this.providerUrl_ + "\n" + "\t-the transaction server is running";
        return string;
    }

    private boolean checkSetup() {
        this.txmgr_ = TransactionManagerImp.getTransactionManager();
        if (this.txmgr_ == null) {
            try {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("java.naming.factory.initial", this.initialContextFactory_);
                hashtable.put("java.naming.provider.url", this.providerUrl_);
                InitialContext initialContext = new InitialContext(hashtable);
                this.txmgrServer_ = (UserTransactionServer)PortableRemoteObject.narrow((Object)initialContext.lookup(this.name_), (Class)(class$com$atomikos$icatch$jta$UserTransactionServer == null ? (class$com$atomikos$icatch$jta$UserTransactionServer = RemoteClientUserTransaction.class$("com.atomikos.icatch.jta.UserTransactionServer")) : class$com$atomikos$icatch$jta$UserTransactionServer));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException(this.getNotFoundMessage());
            }
            if (this.txmgrServer_ == null) {
                throw new RuntimeException(this.getNotFoundMessage());
            }
        }
        return this.txmgr_ != null;
    }

    private synchronized void setThreadMapping(String string) {
        Thread thread = Thread.currentThread();
        this.threadToTidMap_.put(thread, string);
    }

    private synchronized String removeThreadMapping() {
        Thread thread = Thread.currentThread();
        return (String)this.threadToTidMap_.remove(thread);
    }

    private synchronized String getThreadMapping() {
        Thread thread = Thread.currentThread();
        return (String)this.threadToTidMap_.get(thread);
    }

    public void begin() throws NotSupportedException, SystemException {
        boolean bl = this.checkSetup();
        if (bl) {
            this.txmgr_.begin();
        } else {
            String string = this.getThreadMapping();
            if (string != null) {
                throw new NotSupportedException("Nested transaction not allowed here");
            }
            try {
                string = this.txmgrServer_.begin(this.timeout_);
            }
            catch (RemoteException remoteException) {
                throw new SystemException(remoteException.getMessage());
            }
            this.setThreadMapping(string);
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, IllegalStateException, SecurityException {
        boolean bl = this.checkSetup();
        if (bl) {
            this.txmgr_.commit();
        } else {
            if (this.imported_) {
                throw new SecurityException("Commit not allowed: not creator");
            }
            String string = this.removeThreadMapping();
            if (string == null) {
                throw new IllegalStateException("No transaction for thread");
            }
            try {
                this.txmgrServer_.commit(string);
            }
            catch (RemoteException remoteException) {
                throw new SystemException(remoteException.getMessage());
            }
        }
    }

    public void rollback() throws IllegalStateException, SystemException, SecurityException {
        boolean bl = this.checkSetup();
        if (bl) {
            this.txmgr_.rollback();
        } else {
            if (this.imported_) {
                throw new SecurityException("Rollback not allowed: not creator");
            }
            String string = this.removeThreadMapping();
            if (string == null) {
                throw new IllegalStateException("No transaction for thread");
            }
            try {
                this.txmgrServer_.rollback(string);
            }
            catch (RemoteException remoteException) {
                throw new SystemException(remoteException.getMessage());
            }
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        boolean bl = this.checkSetup();
        if (bl) {
            this.txmgr_.setRollbackOnly();
        } else {
            String string = this.getThreadMapping();
            if (string == null) {
                throw new IllegalStateException("No transaction for thread");
            }
            try {
                this.txmgrServer_.setRollbackOnly(string);
            }
            catch (RemoteException remoteException) {
                throw new SystemException(remoteException.getMessage());
            }
        }
    }

    public int getStatus() throws SystemException {
        int n = 6;
        boolean bl = this.checkSetup();
        if (bl) {
            n = this.txmgr_.getStatus();
        } else {
            String string = this.getThreadMapping();
            if (string != null) {
                try {
                    n = this.txmgrServer_.getStatus(string);
                }
                catch (RemoteException remoteException) {
                    throw new SystemException(remoteException.getMessage());
                }
            }
        }
        return n;
    }

    public void setTransactionTimeout(int n) throws SystemException {
        this.timeout_ = n;
    }

    public String toString() {
        String string = null;
        boolean bl = this.checkSetup();
        if (bl) {
            Transaction transaction = null;
            try {
                transaction = this.txmgr_.getTransaction();
            }
            catch (SystemException systemException) {
                String string2 = "Error getting transaction";
                Configuration.logWarning((String)string2, (Exception)((Object)systemException));
            }
            if (transaction != null) {
                string = transaction.toString();
            }
        }
        if (string == null) {
            string = this.getThreadMapping();
        }
        return string;
    }

    public Reference getReference() throws NamingException {
        StringRefAddr stringRefAddr = new StringRefAddr("ServerName", this.name_);
        StringRefAddr stringRefAddr2 = new StringRefAddr("ProviderUrl", this.providerUrl_);
        StringRefAddr stringRefAddr3 = new StringRefAddr("ContextFactory", this.initialContextFactory_);
        StringRefAddr stringRefAddr4 = new StringRefAddr("Timeout", new Integer(this.timeout_).toString());
        Reference reference = new Reference(this.getClass().getName(), new StringRefAddr("name", "RemoteClientUserTransaction"), (class$com$atomikos$icatch$jta$RemoteClientUserTransactionFactory == null ? (class$com$atomikos$icatch$jta$RemoteClientUserTransactionFactory = RemoteClientUserTransaction.class$("com.atomikos.icatch.jta.RemoteClientUserTransactionFactory")) : class$com$atomikos$icatch$jta$RemoteClientUserTransactionFactory).getName(), null);
        reference.add(stringRefAddr);
        reference.add(stringRefAddr2);
        reference.add(stringRefAddr3);
        reference.add(stringRefAddr4);
        return reference;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        String string = this.getThreadMapping();
        objectOutput.writeObject(string);
        objectOutput.writeObject(this.name_);
        objectOutput.writeObject(this.initialContextFactory_);
        objectOutput.writeObject(this.providerUrl_);
        objectOutput.writeInt(this.timeout_);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = (String)objectInput.readObject();
        if (string != null) {
            this.setThreadMapping(string);
            this.imported_ = true;
        }
        this.name_ = (String)objectInput.readObject();
        this.initialContextFactory_ = (String)objectInput.readObject();
        this.providerUrl_ = (String)objectInput.readObject();
        this.timeout_ = objectInput.readInt();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

