/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.xa.TemporaryXATransactionalResource;
import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.icatch.CompositeTerminator;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionControl;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.jta.ExtendedSystemException;
import com.atomikos.icatch.jta.Sync2Sync;
import com.atomikos.icatch.jta.XAResourceKey;
import com.atomikos.icatch.system.Configuration;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

class TransactionImp
implements Transaction {
    protected CompositeTransaction ct_;
    protected Map xaresToTxMap_;
    protected Stack suspendstack_;
    protected boolean autoRegistration_;

    TransactionImp(CompositeTransaction compositeTransaction, boolean bl) {
        this.ct_ = compositeTransaction;
        this.autoRegistration_ = bl;
        this.xaresToTxMap_ = new HashMap();
    }

    void setSuspendedStack(Stack stack) {
        this.suspendstack_ = stack;
    }

    CompositeTransaction getCT() {
        return this.ct_;
    }

    Stack getSuspendedStack() {
        return this.suspendstack_;
    }

    private void printMsg(String string, int n) {
        if (n == 1) {
            Configuration.logWarning((String)string);
        } else if (n == 2) {
            Configuration.logInfo((String)string);
        } else {
            Configuration.logDebug((String)string);
        }
    }

    private synchronized void addXAResourceTransaction(XAResourceTransaction xAResourceTransaction, XAResource xAResource) {
        this.xaresToTxMap_.put(new XAResourceKey(xAResource), xAResourceTransaction);
    }

    private synchronized XAResourceTransaction findXAResourceTransaction(XAResource xAResource) {
        XAResourceTransaction xAResourceTransaction = null;
        xAResourceTransaction = (XAResourceTransaction)this.xaresToTxMap_.get(new XAResourceKey(xAResource));
        return xAResourceTransaction;
    }

    private synchronized void removeXAResourceTransaction(XAResource xAResource) {
        this.xaresToTxMap_.remove(new XAResourceKey(xAResource));
    }

    public void registerSynchronization(javax.transaction.Synchronization synchronization) throws IllegalStateException, SystemException {
        try {
            Sync2Sync sync2Sync = new Sync2Sync(synchronization);
            this.ct_.registerSynchronization((Synchronization)sync2Sync);
        }
        catch (SysException sysException) {
            throw new ExtendedSystemException(sysException.getMessage(), sysException.getErrors());
        }
    }

    public int getStatus() {
        TxState txState = (TxState)this.ct_.getState();
        if (txState.equals((Object)TxState.IN_DOUBT)) {
            return 2;
        }
        if (txState.equals((Object)TxState.PREPARING)) {
            return 7;
        }
        if (txState.equals((Object)TxState.ACTIVE)) {
            return 0;
        }
        if (txState.equals((Object)TxState.MARKED_ABORT)) {
            return 1;
        }
        return 5;
    }

    public void commit() throws javax.transaction.RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, SecurityException {
        TransactionControl transactionControl = this.ct_.getTransactionControl();
        if (transactionControl == null) {
            throw new SecurityException("No control object found");
        }
        CompositeTerminator compositeTerminator = transactionControl.getTerminator();
        if (compositeTerminator == null) {
            throw new SecurityException("No terminator found");
        }
        try {
            compositeTerminator.commit();
        }
        catch (HeurHazardException heurHazardException) {
            throw new HeuristicMixedException(heurHazardException.getMessage());
        }
        catch (HeurRollbackException heurRollbackException) {
            throw new HeuristicRollbackException(heurRollbackException.getMessage());
        }
        catch (HeurMixedException heurMixedException) {
            throw new HeuristicMixedException(heurMixedException.getMessage());
        }
        catch (SysException sysException) {
            throw new ExtendedSystemException(sysException.getMessage(), sysException.getErrors());
        }
        catch (RollbackException rollbackException) {
            throw new javax.transaction.RollbackException(rollbackException.getMessage());
        }
    }

    public void rollback() throws IllegalStateException, SystemException {
        TransactionControl transactionControl = this.ct_.getTransactionControl();
        if (transactionControl == null) {
            throw new SystemException("No control object found");
        }
        CompositeTerminator compositeTerminator = transactionControl.getTerminator();
        if (compositeTerminator == null) {
            throw new SystemException("No terminator found");
        }
        try {
            compositeTerminator.rollback();
        }
        catch (SysException sysException) {
            throw new ExtendedSystemException(sysException.getMessage(), sysException.getErrors());
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.ct_.getTransactionControl().setRollbackOnly();
    }

    public boolean enlistResource(XAResource xAResource) throws javax.transaction.RollbackException, SystemException, IllegalStateException {
        Object object;
        XATransactionalResource xATransactionalResource = null;
        XATransactionalResource xATransactionalResource2 = null;
        XAResourceTransaction xAResourceTransaction = null;
        Stack<Throwable> stack = new Stack<Throwable>();
        if (this.getStatus() == 1) {
            throw new javax.transaction.RollbackException("Transaction is set to rollback.");
        }
        Enumeration enumeration = Configuration.getResources();
        while (enumeration.hasMoreElements()) {
            object = (RecoverableResource)enumeration.nextElement();
            if (!(object instanceof XATransactionalResource) || !(xATransactionalResource2 = (XATransactionalResource)object).usesXAResource(xAResource)) continue;
            xATransactionalResource = xATransactionalResource2;
        }
        this.printMsg("enlistResource ( " + xAResource + " ) with transaction " + this.toString(), 2);
        if (xATransactionalResource == null) {
            if (this.autoRegistration_) {
                this.printMsg("constructing new temporary resource for unknown XAResource: " + xAResource, 3);
                xATransactionalResource = new TemporaryXATransactionalResource(xAResource);
                Configuration.addResource((RecoverableResource)xATransactionalResource);
            } else {
                throw new SystemException("Unknown resource");
            }
        }
        if ((object = this.findXAResourceTransaction(xAResource)) != null) {
            if (!((XAResourceTransaction)object).isXaSuspended()) {
                throw new IllegalStateException("XAResource instance enlisted a second time without delist in between?");
            }
            try {
                xAResourceTransaction.setXAResource(xAResource);
                ((XAResourceTransaction)object).xaResume();
            }
            catch (XAException xAException) {
                if (100 <= xAException.errorCode && xAException.errorCode <= 107) {
                    throw new javax.transaction.RollbackException("Transaction was rolled back in resource.");
                }
                stack.push(xAException);
                throw new ExtendedSystemException("Error in resume", stack);
            }
        }
        try {
            xAResourceTransaction = (XAResourceTransaction)xATransactionalResource.getResourceTransaction(this.ct_);
            xAResourceTransaction.setXAResource(xAResource);
            xAResourceTransaction.resume();
        }
        catch (ResourceException resourceException) {
            Stack stack2 = resourceException.getDetails();
            if (!stack2.empty() && stack2.peek() instanceof XAException) {
                XAException xAException = (XAException)stack2.peek();
                if (100 <= xAException.errorCode && xAException.errorCode <= 107) {
                    throw new javax.transaction.RollbackException("Transaction was rolled back in resource.");
                }
            }
            stack.push(resourceException);
            throw new ExtendedSystemException("Error in resume", stack);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        this.addXAResourceTransaction(xAResourceTransaction, xAResource);
        return true;
    }

    public boolean delistResource(XAResource xAResource, int n) throws IllegalStateException, SystemException {
        Object object;
        Stack<Throwable> stack = new Stack<Throwable>();
        XATransactionalResource xATransactionalResource = null;
        Enumeration enumeration = Configuration.getResources();
        while (enumeration.hasMoreElements()) {
            XATransactionalResource xATransactionalResource2;
            object = (RecoverableResource)enumeration.nextElement();
            if (!(object instanceof XATransactionalResource) || !(xATransactionalResource2 = (XATransactionalResource)object).usesXAResource(xAResource)) continue;
            xATransactionalResource = xATransactionalResource2;
        }
        this.printMsg("delistResource ( " + xAResource + " ) with transaction " + this.toString(), 2);
        if (xATransactionalResource == null) {
            throw new SystemException("Unknown resource");
        }
        object = this.findXAResourceTransaction(xAResource);
        if (object == null) {
            throw new IllegalStateException("Resource not enlisted?");
        }
        if (n == 0x4000000 || n == 0x20000000) {
            try {
                ((XAResourceTransaction)object).suspend();
            }
            catch (ResourceException resourceException) {
                stack.push(resourceException);
                throw new ExtendedSystemException("Error in ending", stack);
            }
            this.removeXAResourceTransaction(xAResource);
            if (n == 0x20000000) {
                this.setRollbackOnly();
            }
        } else if (n == 0x2000000) {
            try {
                ((XAResourceTransaction)object).xaSuspend();
            }
            catch (XAException xAException) {
                stack.push(xAException);
                throw new ExtendedSystemException("Error in ending", stack);
            }
        } else {
            throw new SystemException("Unknown flag :" + n);
        }
        return true;
    }

    private void printXAResources() {
        Iterator iterator = this.xaresToTxMap_.keySet().iterator();
        while (iterator.hasNext()) {
            XAResourceKey xAResourceKey = (XAResourceKey)iterator.next();
            System.out.println("Found XAResource " + xAResourceKey.toString());
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TransactionImp)) {
            return false;
        }
        TransactionImp transactionImp = (TransactionImp)object;
        return this.ct_.isSameTransaction(transactionImp.ct_);
    }

    public int hashCode() {
        return this.ct_.hashCode();
    }

    public String toString() {
        return this.ct_.getTid().toString();
    }
}

