/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.ResumePreviousTransactionSubTxAwareParticipant;
import com.atomikos.icatch.jta.ExtendedSystemException;
import com.atomikos.icatch.jta.TransactionImp;
import com.atomikos.icatch.system.Configuration;
import java.util.Hashtable;
import java.util.Stack;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class TransactionManagerImp
implements TransactionManager,
SubTxAwareParticipant,
Referenceable {
    public static final String JTA_PROPERTY_NAME = "com.atomikos.icatch.jta.transaction";
    private static TransactionManagerImp singleton_ = null;
    public static final int DEFAULT_TIMEOUT = 10;
    private static boolean default_serial = false;
    private int timeout_;
    private Hashtable txmap_;
    private CompositeTransactionManager ctm_;
    private int count_;
    private boolean automaticResourceRegistration_;
    static /* synthetic */ Class class$com$atomikos$icatch$jta$TransactionManagerFactory;

    private static final void raiseNoTransaction() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("This method needs a transaction for the calling thread and none exists.\n");
        stringBuffer.append("Possible causes: either you didn't start a transaction,\n");
        stringBuffer.append("it rolledback due to timeout, or it was committed already.\n");
        stringBuffer.append("ACTIONS: You can try one of the following: \n");
        stringBuffer.append("1. Make sure you started a transaction for the thread.\n");
        stringBuffer.append("2. Make sure you didn't terminate it yet.\n");
        stringBuffer.append("3. Increase the transaction timeout to avoid automatic rollback of long transactions;\n");
        stringBuffer.append("   check http://www.atomikos.org/forums/viewtopic.php?t=1259 for how to do this.");
        throw new IllegalStateException(stringBuffer.toString());
    }

    public static void setDefaultSerial(boolean bl) {
        default_serial = bl;
    }

    public static boolean getDefaultSerial() {
        return default_serial;
    }

    public static synchronized void installTransactionManager(CompositeTransactionManager compositeTransactionManager, boolean bl) {
        singleton_ = compositeTransactionManager == null ? null : new TransactionManagerImp(compositeTransactionManager, bl);
    }

    public static TransactionManager getTransactionManager() {
        return singleton_;
    }

    private TransactionManagerImp(CompositeTransactionManager compositeTransactionManager, boolean bl) {
        this.ctm_ = compositeTransactionManager;
        this.count_ = 0;
        this.timeout_ = 10;
        this.txmap_ = new Hashtable();
        this.automaticResourceRegistration_ = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToMap(String string, TransactionImp transactionImp) {
        Hashtable hashtable = this.txmap_;
        synchronized (hashtable) {
            this.txmap_.put(string.toString(), transactionImp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromMap(String string) {
        Hashtable hashtable = this.txmap_;
        synchronized (hashtable) {
            this.txmap_.remove(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionImp getPreviousInstance(String string) {
        Hashtable hashtable = this.txmap_;
        synchronized (hashtable) {
            if (this.txmap_.containsKey(string.toString())) {
                return (TransactionImp)this.txmap_.get(string.toString());
            }
            return null;
        }
    }

    public Transaction getTransaction(String string) {
        return this.getPreviousInstance(string);
    }

    public void begin() throws NotSupportedException, SystemException {
        this.begin(this.timeout_);
    }

    public void begin(int n) throws NotSupportedException, SystemException {
        Thread thread = Thread.currentThread();
        TransactionImp transactionImp = null;
        CompositeTransaction compositeTransaction = null;
        ResumePreviousTransactionSubTxAwareParticipant resumePreviousTransactionSubTxAwareParticipant = null;
        compositeTransaction = this.ctm_.getCompositeTransaction();
        if (compositeTransaction != null && compositeTransaction.getProperty(JTA_PROPERTY_NAME) == null) {
            Configuration.logWarning((String)("JTA: temporarily suspending incompatible transaction: " + compositeTransaction.getTid() + " (will be resumed after JTA transaction ends)"));
            compositeTransaction = this.ctm_.suspend();
            resumePreviousTransactionSubTxAwareParticipant = new ResumePreviousTransactionSubTxAwareParticipant(compositeTransaction);
        }
        try {
            compositeTransaction = this.ctm_.createCompositeTransaction((long)(n * 1000));
            if (resumePreviousTransactionSubTxAwareParticipant != null) {
                compositeTransaction.addSubTxAwareParticipant(resumePreviousTransactionSubTxAwareParticipant);
            }
            if (compositeTransaction.isRoot() && TransactionManagerImp.getDefaultSerial()) {
                compositeTransaction.getTransactionControl().setSerial();
            }
            compositeTransaction.setProperty(JTA_PROPERTY_NAME, "true");
        }
        catch (SysException sysException) {
            throw new ExtendedSystemException("Error in begin()", sysException.getErrors());
        }
        transactionImp = new TransactionImp(compositeTransaction, this.automaticResourceRegistration_);
        this.addToMap(compositeTransaction.getTid(), transactionImp);
        compositeTransaction.addSubTxAwareParticipant((SubTxAwareParticipant)this);
    }

    public Transaction getTransaction() throws SystemException {
        TransactionImp transactionImp = null;
        CompositeTransaction compositeTransaction = null;
        try {
            compositeTransaction = this.ctm_.getCompositeTransaction();
        }
        catch (SysException sysException) {
            throw new ExtendedSystemException("Error in getTransaction", sysException.getErrors());
        }
        if (compositeTransaction == null || compositeTransaction.getProperty(JTA_PROPERTY_NAME) == null) {
            transactionImp = null;
        } else {
            transactionImp = this.getPreviousInstance(compositeTransaction.getTid());
            if (transactionImp == null && compositeTransaction.getState().equals(TxState.ACTIVE)) {
                transactionImp = new TransactionImp(compositeTransaction, this.automaticResourceRegistration_);
                this.addToMap(compositeTransaction.getTid(), transactionImp);
                compositeTransaction.addSubTxAwareParticipant((SubTxAwareParticipant)this);
            }
        }
        return transactionImp;
    }

    public void setTransactionTimeout(int n) throws SystemException {
        if (n > 0) {
            this.timeout_ = n;
        } else if (n == 0) {
            this.timeout_ = 10;
        } else {
            throw new SystemException("Value must be >= 0");
        }
    }

    public int getTransactionTimeout() {
        return this.timeout_;
    }

    public Transaction suspend() throws SystemException {
        this.getTransaction();
        TransactionImp transactionImp = null;
        CompositeTransaction compositeTransaction = null;
        try {
            compositeTransaction = this.ctm_.suspend();
        }
        catch (SysException sysException) {
            throw new ExtendedSystemException("Error in getTransaction", sysException.getErrors());
        }
        if (compositeTransaction != null) {
            transactionImp = this.getPreviousInstance(compositeTransaction.getTid());
        }
        return transactionImp;
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (transaction == null || !(transaction instanceof TransactionImp)) {
            throw new InvalidTransactionException();
        }
        TransactionImp transactionImp = (TransactionImp)transaction;
        try {
            this.ctm_.resume(transactionImp.getCT());
        }
        catch (SysException sysException) {
            throw new ExtendedSystemException("Error in getTransaction", sysException.getErrors());
        }
    }

    public int getStatus() throws SystemException {
        int n = 6;
        this.getTransaction();
        TransactionImp transactionImp = null;
        CompositeTransaction compositeTransaction = null;
        try {
            compositeTransaction = this.ctm_.getCompositeTransaction();
        }
        catch (SysException sysException) {
            throw new ExtendedSystemException("Error in getTransaction", sysException.getErrors());
        }
        if (compositeTransaction == null) {
            n = 6;
        } else {
            transactionImp = this.getPreviousInstance(compositeTransaction.getTid());
            n = transactionImp.getStatus();
        }
        return n;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, IllegalStateException, SecurityException {
        TransactionImp transactionImp = null;
        CompositeTransaction compositeTransaction = null;
        this.getTransaction();
        try {
            compositeTransaction = this.ctm_.getCompositeTransaction();
        }
        catch (SysException sysException) {
            throw new ExtendedSystemException("Error in getTransaction", sysException.getErrors());
        }
        if (compositeTransaction == null) {
            TransactionManagerImp.raiseNoTransaction();
        } else {
            transactionImp = this.getPreviousInstance(compositeTransaction.getTid());
            transactionImp.commit();
        }
    }

    public void rollback() throws IllegalStateException, SystemException, SecurityException {
        TransactionImp transactionImp = null;
        CompositeTransaction compositeTransaction = null;
        this.getTransaction();
        try {
            compositeTransaction = this.ctm_.getCompositeTransaction();
        }
        catch (SysException sysException) {
            throw new ExtendedSystemException("Error in getTransaction", sysException.getErrors());
        }
        if (compositeTransaction == null) {
            TransactionManagerImp.raiseNoTransaction();
        } else {
            transactionImp = this.getPreviousInstance(compositeTransaction.getTid());
            transactionImp.rollback();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Stack<SecurityException> stack = new Stack<SecurityException>();
        Transaction transaction = this.getTransaction();
        if (transaction == null) {
            TransactionManagerImp.raiseNoTransaction();
        }
        try {
            transaction.setRollbackOnly();
        }
        catch (SecurityException securityException) {
            stack.push(securityException);
            throw new ExtendedSystemException("Unexpected error", stack);
        }
    }

    public void committed(CompositeTransaction compositeTransaction) {
        this.removeFromMap(compositeTransaction.getTid());
    }

    public void rolledback(CompositeTransaction compositeTransaction) {
        this.removeFromMap(compositeTransaction.getTid());
    }

    public Reference getReference() throws NamingException {
        return new Reference(this.getClass().getName(), new StringRefAddr("name", "TransactionManager"), (class$com$atomikos$icatch$jta$TransactionManagerFactory == null ? (class$com$atomikos$icatch$jta$TransactionManagerFactory = TransactionManagerImp.class$("com.atomikos.icatch.jta.TransactionManagerFactory")) : class$com$atomikos$icatch$jta$TransactionManagerFactory).getName(), null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

