/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.nonxa;

import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jdbc.HeuristicDataSource;
import com.atomikos.jdbc.nonxa.DataSourceShutdownHook;
import com.atomikos.jdbc.nonxa.DriverManagerDataSource;
import com.atomikos.jdbc.nonxa.NonXADataSourceImp;
import com.atomikos.util.SerializableObjectFactory;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class NonXADataSourceBean
implements HeuristicDataSource,
Referenceable,
Serializable {
    private String validatingQuery;
    private String jndiName = "some unique name";
    private String url = "";
    private String user = "";
    private String password = "";
    private String driverClassName = "";
    private int poolSize = 2;
    private int connectionTimeout = 15;
    private boolean testOnBorrow = false;
    private transient NonXADataSourceImp delegate;

    private synchronized void checkSetup(boolean bl) throws SQLException {
        this.delegate = NonXADataSourceImp.getInstance(this.jndiName);
        if (this.delegate != null && !bl) {
            return;
        }
        if (this.url == null || this.url.equals("")) {
            throw new SQLException("NonXADataSourceBean: url not set.");
        }
        if (this.driverClassName == null || this.driverClassName.equals("")) {
            throw new SQLException("NonXADataSourceBean: driverClassName not set.");
        }
        DriverManagerDataSource driverManagerDataSource = new DriverManagerDataSource();
        driverManagerDataSource.setDriverClassName(this.driverClassName);
        driverManagerDataSource.setUser(this.user);
        driverManagerDataSource.setPassword(this.password);
        driverManagerDataSource.setUrl(this.url);
        this.delegate = new NonXADataSourceImp(driverManagerDataSource, this.jndiName, this.user, this.password, this.poolSize, this.connectionTimeout, bl, this.validatingQuery, this.testOnBorrow);
        DataSourceShutdownHook dataSourceShutdownHook = new DataSourceShutdownHook(this.delegate);
        Runtime.getRuntime().addShutdownHook(dataSourceShutdownHook);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NonXADataSourceBean configured with [");
        stringBuffer.append("uniqueResourceName=").append(this.jndiName).append(", ");
        stringBuffer.append("url=").append(this.url).append(", ");
        stringBuffer.append("user=").append(this.user).append(", ");
        stringBuffer.append("password=").append(this.password).append(", ");
        stringBuffer.append("driverClassName=").append(this.driverClassName).append(", ");
        stringBuffer.append("poolSize=").append(this.poolSize).append(", ");
        stringBuffer.append("connectionTimeout=").append(this.connectionTimeout).append(", ");
        stringBuffer.append("testOnBorrow=").append(this.testOnBorrow);
        stringBuffer.append("]");
        Configuration.logDebug((String)stringBuffer.toString());
    }

    public Connection getConnection(HeuristicMessage heuristicMessage) throws SQLException {
        this.checkSetup(false);
        return this.delegate.getConnection(heuristicMessage);
    }

    public Connection getConnection(String string, String string2, HeuristicMessage heuristicMessage) throws SQLException {
        this.checkSetup(false);
        return this.delegate.getConnection(string, string2, heuristicMessage);
    }

    public Reference getReference() throws NamingException {
        return SerializableObjectFactory.createReference((Serializable)this);
    }

    public Connection getConnection() throws SQLException {
        this.checkSetup(false);
        return this.delegate.getConnection();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        this.checkSetup(false);
        return this.delegate.getConnection(string, string2);
    }

    public Connection getConnection(String string) throws SQLException {
        this.checkSetup(false);
        return this.delegate.getConnection(string);
    }

    public Connection getConnection(String string, String string2, String string3) throws SQLException {
        this.checkSetup(false);
        return this.delegate.getConnection(string, string2, string3);
    }

    public PrintWriter getLogWriter() throws SQLException {
        this.checkSetup(false);
        return this.delegate.getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.checkSetup(false);
        this.delegate.setLogWriter(printWriter);
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.checkSetup(false);
        this.delegate.setLoginTimeout(n);
    }

    public int getLoginTimeout() throws SQLException {
        this.checkSetup(false);
        return this.delegate.getLoginTimeout();
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getUniqueResourceName() {
        return this.jndiName;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public void setTestOnBorrow(boolean bl) {
        this.testOnBorrow = bl;
    }

    public boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setConnectionTimeout(int n) {
        this.connectionTimeout = n;
    }

    public void setDriverClassName(String string) {
        this.driverClassName = string;
    }

    public void setUniqueResourceName(String string) {
        this.jndiName = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setPoolSize(int n) {
        this.poolSize = n;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setValidatingQuery(String string) {
        this.validatingQuery = string;
    }

    public String getValidatingQuery() {
        return this.validatingQuery;
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws SQLException {
        this.checkSetup(true);
        String string = this.getValidatingQuery();
        if (string == null || string.equals("")) {
            return;
        }
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.delegate.getConnection();
            try {
                statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                statement.close();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

