/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.nonxa;

import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.jdbc.ConnectionPool;
import com.atomikos.jdbc.HeuristicDataSource;
import com.atomikos.jdbc.XPooledConnection;
import com.atomikos.jdbc.nonxa.NonXAConnectionFactory;
import com.atomikos.jdbc.nonxa.NonXAPooledConnectionImp;
import com.atomikos.jdbc.nonxa.ThreadLocalConnection;
import java.io.PrintWriter;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;

public class NonXADataSourceImp
implements HeuristicDataSource,
ConnectionEventListener,
Referenceable {
    private Map previousConnections;
    private ConnectionPool pool;
    private String jndiName;
    private static Map nameToDataSource_ = new HashMap();
    static /* synthetic */ Class class$com$atomikos$jdbc$nonxa$NonXADataSourceImpFactory;

    static NonXADataSourceImp getInstance(String string) {
        NonXADataSourceImp nonXADataSourceImp = (NonXADataSourceImp)nameToDataSource_.get(string);
        return nonXADataSourceImp;
    }

    private static synchronized void addToMap(String string, NonXADataSourceImp nonXADataSourceImp) throws SQLException {
        if (nameToDataSource_.get(string) != null) {
            throw new SQLException("DataSource for resource " + string + " already exists!");
        }
        nameToDataSource_.put(string, nonXADataSourceImp);
    }

    private static synchronized void removeFromMap(String string) {
        if (string != null && nameToDataSource_ != null) {
            nameToDataSource_.remove(string);
        }
    }

    public NonXADataSourceImp(DataSource dataSource, String string, String string2, String string3, int n, int n2, String string4, boolean bl) throws SQLException {
        this(dataSource, string, string2, string3, n, n2, false, string4, bl);
    }

    public NonXADataSourceImp(DataSource dataSource, String string, String string2, String string3, int n, int n2, boolean bl, String string4, boolean bl2) throws SQLException {
        NonXAConnectionFactory nonXAConnectionFactory = new NonXAConnectionFactory(dataSource, string2, string3);
        this.pool = new ConnectionPool(n, nonXAConnectionFactory, n2, string4, bl2);
        this.previousConnections = new HashMap();
        this.jndiName = string;
        if (!bl) {
            NonXADataSourceImp.addToMap(string, this);
        }
    }

    public Connection getConnection(String string) throws SQLException {
        StringHeuristicMessage stringHeuristicMessage = new StringHeuristicMessage(string);
        return this.getConnection((HeuristicMessage)stringHeuristicMessage);
    }

    public Connection getConnection(String string, String string2, String string3) throws SQLException {
        StringHeuristicMessage stringHeuristicMessage = new StringHeuristicMessage(string3);
        return this.getConnection(string, string2, (HeuristicMessage)stringHeuristicMessage);
    }

    public synchronized Connection getConnection(HeuristicMessage heuristicMessage) throws SQLException {
        Object object;
        Connection connection = (Connection)this.previousConnections.get(Thread.currentThread());
        if (connection == null) {
            object = (NonXAPooledConnectionImp)this.pool.getPooledConnection();
            ((NonXAPooledConnectionImp)object).addConnectionEventListener(this);
            connection = (Connection)ThreadLocalConnection.newInstance((NonXAPooledConnectionImp)object);
            this.previousConnections.put(Thread.currentThread(), connection);
        }
        object = (ThreadLocalConnection)Proxy.getInvocationHandler(connection);
        ((ThreadLocalConnection)object).incUseCount();
        ((ThreadLocalConnection)object).addHeuristicMessage(heuristicMessage);
        return connection;
    }

    public Connection getConnection(String string, String string2, HeuristicMessage heuristicMessage) throws SQLException {
        throw new SQLException("Not supported: getConnection with authentication.");
    }

    public Connection getConnection() throws SQLException {
        HeuristicMessage heuristicMessage = null;
        return this.getConnection(heuristicMessage);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        HeuristicMessage heuristicMessage = null;
        return this.getConnection(string, string2, heuristicMessage);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.pool.getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.pool.setLogWriter(printWriter);
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.pool.setLoginTimeout(n);
    }

    public int getLoginTimeout() throws SQLException {
        return this.pool.getLoginTimeout();
    }

    public synchronized void connectionClosed(ConnectionEvent connectionEvent) {
        XPooledConnection xPooledConnection = (XPooledConnection)connectionEvent.getSource();
        Set set = this.previousConnections.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Connection connection = (Connection)entry.getValue();
            ThreadLocalConnection threadLocalConnection = (ThreadLocalConnection)Proxy.getInvocationHandler(connection);
            if (!threadLocalConnection.usesConnection(xPooledConnection)) continue;
            iterator.remove();
        }
        xPooledConnection.removeConnectionEventListener(this);
        this.pool.putBack(xPooledConnection);
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
    }

    public void close() {
        this.pool.cleanup();
        NonXADataSourceImp.removeFromMap(this.jndiName);
    }

    public Reference getReference() throws NamingException {
        StringRefAddr stringRefAddr = new StringRefAddr("ResourceName", this.jndiName);
        Reference reference = new Reference(this.getClass().getName(), new StringRefAddr("name", "NonXADataSourceImp"), (class$com$atomikos$jdbc$nonxa$NonXADataSourceImpFactory == null ? (class$com$atomikos$jdbc$nonxa$NonXADataSourceImpFactory = NonXADataSourceImp.class$("com.atomikos.jdbc.nonxa.NonXADataSourceImpFactory")) : class$com$atomikos$jdbc$nonxa$NonXADataSourceImpFactory).getName(), null);
        reference.add(stringRefAddr);
        return reference;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

