/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.system.Configuration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.transaction.xa.XAResource;

class DefaultJtaMessageProducer
implements MessageProducer {
    private TransactionalResource res_;
    private XAResourceTransaction restx_;
    private XAResource xares_;
    private MessageProducer sender_;

    protected DefaultJtaMessageProducer(MessageProducer messageProducer, TransactionalResource transactionalResource, XAResource xAResource) {
        this.sender_ = messageProducer;
        this.res_ = transactionalResource;
        this.restx_ = null;
        this.xares_ = xAResource;
    }

    protected MessageProducer getMessageProducer() {
        return this.sender_;
    }

    protected synchronized void enlist(HeuristicMessage heuristicMessage) throws JMSException {
        if (this.restx_ != null) {
            throw new JMSException("JtaMessageProducer.enlist: already enlisted");
        }
        CompositeTransactionManager compositeTransactionManager = Configuration.getCompositeTransactionManager();
        if (compositeTransactionManager == null) {
            throw new JMSException("JTA MessageProducer: requires Atomikos TransactionsEssentials to be running! Please make sure to start a transaction first.");
        }
        CompositeTransaction compositeTransaction = compositeTransactionManager.getCompositeTransaction();
        if (compositeTransaction == null || compositeTransaction.getProperty("com.atomikos.icatch.jta.transaction") == null) {
            throw new JMSException("JTA transaction required for JtaMessageProducer");
        }
        this.restx_ = (XAResourceTransaction)this.res_.getResourceTransaction(compositeTransaction);
        this.restx_.setXAResource(this.xares_);
        this.restx_.resume();
        if (heuristicMessage != null) {
            this.restx_.addHeuristicMessage(heuristicMessage);
        }
    }

    protected synchronized void delist() throws JMSException {
        if (this.restx_ == null) {
            throw new JMSException("JtaMessageProducer.delist: not enlisted");
        }
        this.restx_.suspend();
        this.restx_ = null;
    }

    public void setDisableMessageID(boolean bl) throws JMSException {
        this.sender_.setDisableMessageID(bl);
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.sender_.getDisableMessageID();
    }

    public void setDisableMessageTimestamp(boolean bl) throws JMSException {
        this.sender_.setDisableMessageTimestamp(bl);
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.sender_.getDisableMessageTimestamp();
    }

    public void setDeliveryMode(int n) throws JMSException {
        this.sender_.setDeliveryMode(n);
    }

    public int getDeliveryMode() throws JMSException {
        return this.sender_.getDeliveryMode();
    }

    public void setPriority(int n) throws JMSException {
        this.sender_.setPriority(n);
    }

    public int getPriority() throws JMSException {
        return this.sender_.getPriority();
    }

    public void setTimeToLive(long l) throws JMSException {
        this.sender_.setTimeToLive(l);
    }

    public long getTimeToLive() throws JMSException {
        return this.sender_.getTimeToLive();
    }

    public Destination getDestination() throws JMSException {
        return this.sender_.getDestination();
    }

    public void close() throws JMSException {
        this.sender_.close();
    }

    public void send(Message message) throws JMSException {
        this.sendToDefaultDestination(message, null);
    }

    public void send(Message message, int n, int n2, long l) throws JMSException {
        this.sendToDefaultDestination(message, n, n2, l, null);
    }

    public void send(Destination destination, Message message) throws JMSException {
        StringHeuristicMessage stringHeuristicMessage = new StringHeuristicMessage("Sending of JMS Message with ID: " + message.getJMSMessageID());
        this.sendToDestination(destination, message, (HeuristicMessage)stringHeuristicMessage);
    }

    public void send(Destination destination, Message message, int n, int n2, long l) throws JMSException {
        StringHeuristicMessage stringHeuristicMessage = new StringHeuristicMessage("Sending of JMS Message with ID: " + message.getJMSMessageID());
        this.sendToDestination(destination, message, n, n2, l, (HeuristicMessage)stringHeuristicMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToDefaultDestination(Message message, int n, int n2, long l, HeuristicMessage heuristicMessage) throws JMSException {
        this.enlist(heuristicMessage);
        try {
            this.sender_.send(message, n, n2, l);
        }
        finally {
            this.delist();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToDefaultDestination(Message message, HeuristicMessage heuristicMessage) throws JMSException {
        this.enlist(heuristicMessage);
        try {
            this.sender_.send(message);
        }
        finally {
            this.delist();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToDestination(Destination destination, Message message, int n, int n2, long l, HeuristicMessage heuristicMessage) throws JMSException {
        this.enlist(heuristicMessage);
        try {
            this.sender_.send(destination, message, n, n2, l);
        }
        finally {
            this.delist();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToDestination(Destination destination, Message message, HeuristicMessage heuristicMessage) throws JMSException {
        this.enlist(heuristicMessage);
        try {
            this.sender_.send(destination, message);
        }
        finally {
            this.delist();
        }
    }
}

