/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.jms.DefaultJtaConnection;
import com.atomikos.jms.JtaQueueSession;
import javax.jms.ConnectionConsumer;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;

class JtaQueueConnection
extends DefaultJtaConnection
implements QueueConnection {
    JtaQueueConnection(XAQueueConnection xAQueueConnection, TransactionalResource transactionalResource) {
        super((XAConnection)xAQueueConnection, transactionalResource);
    }

    private XAQueueConnection getQueueConnection() {
        return (XAQueueConnection)this.getConnection();
    }

    public QueueSession createQueueSession(boolean bl, int n) throws JMSException {
        QueueSession queueSession = null;
        if (!bl && !JtaQueueConnection.inJtaTransaction()) {
            queueSession = this.getQueueConnection().createQueueSession(false, n);
        } else {
            JtaQueueConnection.forceConnectionIntoXaMode(this.getConnection());
            XAQueueSession xAQueueSession = this.getQueueConnection().createXAQueueSession();
            queueSession = new JtaQueueSession(xAQueueSession, this.getTransactionalResource(), xAQueueSession.getXAResource());
        }
        return queueSession;
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        throw new JMSException("Not implemented");
    }

    public Session createSession(boolean bl, int n) throws JMSException {
        return this.createQueueSession(bl, n);
    }
}

