/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.icatch.jta.UserTransactionManager;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.AbstractConnectionFactoryBean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

public abstract class MessageConsumerSession {
    private static final int DEFAULT_TIMEOUT = 30;
    private AbstractConnectionFactoryBean factory;
    private String user;
    private String password;
    private Destination destination;
    private int timeout = 30;
    private boolean notifyListenerOnClose;
    private String messageSelector;
    private boolean daemonThreads;
    private transient MessageListener listener;
    protected transient Thread current;
    private UserTransactionManager tm = new UserTransactionManager();
    private boolean active;
    private ExceptionListener exceptionListener;

    protected MessageConsumerSession() {
    }

    protected void setAbstractConnectionFactoryBean(AbstractConnectionFactoryBean abstractConnectionFactoryBean) {
        this.factory = abstractConnectionFactoryBean;
    }

    protected AbstractConnectionFactoryBean getAbstractConnectionFactoryBean() {
        return this.factory;
    }

    public void setDaemonThreads(boolean bl) {
        this.daemonThreads = bl;
    }

    public boolean getDaemonThreads() {
        return this.daemonThreads;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String string) {
        this.messageSelector = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public void setTransactionTimeout(int n) {
        this.timeout = n;
    }

    public int getTransactionTimeout() {
        return this.timeout;
    }

    public void setMessageListener(MessageListener messageListener) {
        this.listener = messageListener;
    }

    public MessageListener getMessageListener() {
        return this.listener;
    }

    public void startListening() throws JMSException, SystemException {
        if (this.destination == null) {
            throw new JMSException("Please set the Destination first");
        }
        if (this.factory == null) {
            throw new JMSException("Please set the ConnectionFactory first");
        }
        this.tm.setStartupTransactionService(true);
        this.tm.init();
        this.tm.setStartupTransactionService(false);
        this.active = true;
        this.startNewThread();
    }

    protected void startNewThread() {
        if (this.active) {
            this.current = new ReceiverThread();
            this.current.setDaemon(this.daemonThreads);
            this.current.start();
            Configuration.logDebug((String)("MessageConsumerSession: started new thread: " + this.current));
        }
    }

    private synchronized void notifyExceptionListener(JMSException jMSException) {
        if (this.exceptionListener != null) {
            this.exceptionListener.onException(jMSException);
        }
    }

    public void stopListening() {
        this.current = null;
        this.tm.close();
        this.active = false;
    }

    public boolean getNotifyListenerOnClose() {
        return this.notifyListenerOnClose;
    }

    public void setNotifyListenerOnClose(boolean bl) {
        this.notifyListenerOnClose = bl;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    class ReceiverThread
    extends Thread {
        private Connection connection;
        private Session session;

        private ReceiverThread() {
        }

        private synchronized MessageConsumer refresh() throws JMSException {
            MessageConsumer messageConsumer = null;
            this.connection = MessageConsumerSession.this.user != null ? MessageConsumerSession.this.factory.createConnection(MessageConsumerSession.this.user, MessageConsumerSession.this.password) : MessageConsumerSession.this.factory.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(true, 0);
            messageConsumer = MessageConsumerSession.this.getMessageSelector() != null ? this.session.createConsumer(MessageConsumerSession.this.destination, MessageConsumerSession.this.getMessageSelector()) : this.session.createConsumer(MessageConsumerSession.this.destination);
            return messageConsumer;
        }

        private synchronized void close() {
            if (this.session != null) {
                try {
                    this.session.close();
                    this.session = null;
                }
                catch (JMSException jMSException) {
                    Configuration.logInfo((String)"MessageConsumerSession: Error closing JMS session", (Exception)((Object)jMSException));
                }
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                    this.connection = null;
                }
                catch (JMSException jMSException) {
                    Configuration.logInfo((String)"MessageConsumerSession: Error closing JMS connection", (Exception)((Object)jMSException));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            MessageConsumer messageConsumer = null;
            try {
                MessageConsumerSession.this.tm.setTransactionTimeout(MessageConsumerSession.this.timeout);
            }
            catch (SystemException systemException) {
                Configuration.logWarning((String)"MessageConsumerSession: Error in JMS thread while setting transaction timeout", (Exception)((Object)systemException));
            }
            Configuration.logInfo((String)"MessageConsumerSession: Starting JMS listener thread.");
            while (Thread.currentThread() == MessageConsumerSession.this.current) {
                Exception exception3222;
                SystemException systemException2222;
                Configuration.logDebug((String)"MessageConsumerSession: JMS listener thread iterating...");
                boolean bl = false;
                boolean bl2 = true;
                Message message = null;
                if (messageConsumer == null) {
                    messageConsumer = this.refresh();
                }
                MessageConsumerSession.this.tm.setTransactionTimeout(MessageConsumerSession.this.timeout);
                if (MessageConsumerSession.this.tm.getTransaction() != null) {
                    Configuration.logWarning((String)("MessageConsumerSession: Detected pending transaction: " + MessageConsumerSession.this.tm.getTransaction()));
                    throw new IllegalStateException("Can't reuse listener thread with pending transaction!");
                }
                MessageConsumerSession.this.tm.begin();
                message = messageConsumer.receive((long)(MessageConsumerSession.this.timeout * 1000 / 2));
                try {
                    if (message != null && MessageConsumerSession.this.listener != null && Thread.currentThread() == MessageConsumerSession.this.current) {
                        Configuration.logInfo((String)("MessageConsumerSession: Consuming message: " + message.toString()));
                        MessageConsumerSession.this.listener.onMessage(message);
                        Configuration.logDebug((String)("MessageConsumerSession: Consumed message: " + message.toString()));
                    } else {
                        bl2 = false;
                    }
                }
                catch (Exception exception2) {
                    Configuration.logInfo((String)("MessageConsumerSession: Error during JMS processing of message " + message.toString() + " - rolling back."), (Exception)exception2);
                    bl2 = false;
                }
                Object var7_10 = null;
                try {
                    if (bl2) {
                        MessageConsumerSession.this.tm.commit();
                    } else {
                        MessageConsumerSession.this.tm.rollback();
                    }
                }
                catch (RollbackException throwable2) {
                    Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Exception)throwable2);
                }
                catch (HeuristicMixedException throwable2) {
                    Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Exception)throwable2);
                }
                catch (HeuristicRollbackException throwable2) {
                    Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Exception)throwable2);
                }
                catch (Exception throwable2) {
                    Configuration.logWarning((String)"MessageConsumerSession: Error ending thread tx association", (Exception)throwable2);
                    try {
                        Configuration.logDebug((String)"MessageConsumerSession: Suspending any active transaction...");
                        MessageConsumerSession.this.tm.suspend();
                    }
                    catch (SystemException systemException2222) {
                        Configuration.logDebug((String)"MessageConsumerSession: Error suspending transaction", (Exception)((Object)systemException2222));
                        try {
                            Configuration.logDebug((String)"MessageConsumerSession: Starting new thread...");
                            MessageConsumerSession.this.startNewThread();
                        }
                        catch (Exception exception3222) {
                            Configuration.logWarning((String)"MessageConsumerSession: Error starting new thread - stopping listener", (Exception)throwable2);
                            MessageConsumerSession.this.stopListening();
                        }
                    }
                }
                if (!bl) continue;
                messageConsumer = null;
                this.close();
                {
                    continue;
                    catch (JMSException jMSException) {
                        Configuration.logWarning((String)"MessageConsumerSession: Error in JMS thread", (Exception)((Object)jMSException));
                        bl = true;
                        bl2 = false;
                        MessageConsumerSession.this.notifyExceptionListener(jMSException);
                        var7_10 = null;
                        try {
                            if (bl2) {
                                MessageConsumerSession.this.tm.commit();
                            } else {
                                MessageConsumerSession.this.tm.rollback();
                            }
                        }
                        catch (RollbackException throwable2) {
                            Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Exception)throwable2);
                        }
                        catch (HeuristicMixedException throwable2) {
                            Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Exception)throwable2);
                        }
                        catch (HeuristicRollbackException throwable2) {
                            Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Exception)throwable2);
                        }
                        catch (Exception throwable2) {
                            Configuration.logWarning((String)"MessageConsumerSession: Error ending thread tx association", (Exception)throwable2);
                            try {
                                Configuration.logDebug((String)"MessageConsumerSession: Suspending any active transaction...");
                                MessageConsumerSession.this.tm.suspend();
                            }
                            catch (SystemException systemException2222) {
                                Configuration.logDebug((String)"MessageConsumerSession: Error suspending transaction", (Exception)((Object)systemException2222));
                                try {
                                    Configuration.logDebug((String)"MessageConsumerSession: Starting new thread...");
                                    MessageConsumerSession.this.startNewThread();
                                }
                                catch (Exception exception3222) {
                                    Configuration.logWarning((String)"MessageConsumerSession: Error starting new thread - stopping listener", (Exception)throwable2);
                                    MessageConsumerSession.this.stopListening();
                                }
                            }
                        }
                        if (!bl) continue;
                        messageConsumer = null;
                        this.close();
                        continue;
                    }
                    catch (Exception exception4) {
                        Configuration.logWarning((String)"MessageConsumerSession: Error in JMS thread", (Exception)exception4);
                        bl = true;
                        bl2 = false;
                        JMSException jMSException = new JMSException("Unexpected error - please see Atomikos console file for more info");
                        MessageConsumerSession.this.notifyExceptionListener(jMSException);
                        var7_10 = null;
                        try {
                            if (bl2) {
                                MessageConsumerSession.this.tm.commit();
                            } else {
                                MessageConsumerSession.this.tm.rollback();
                            }
                        }
                        catch (RollbackException throwable2) {
                            Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Exception)throwable2);
                        }
                        catch (HeuristicMixedException throwable2) {
                            Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Exception)throwable2);
                        }
                        catch (HeuristicRollbackException throwable2) {
                            Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Exception)throwable2);
                        }
                        catch (Exception throwable2) {
                            Configuration.logWarning((String)"MessageConsumerSession: Error ending thread tx association", (Exception)throwable2);
                            try {
                                Configuration.logDebug((String)"MessageConsumerSession: Suspending any active transaction...");
                                MessageConsumerSession.this.tm.suspend();
                            }
                            catch (SystemException systemException2222) {
                                Configuration.logDebug((String)"MessageConsumerSession: Error suspending transaction", (Exception)((Object)systemException2222));
                                try {
                                    Configuration.logDebug((String)"MessageConsumerSession: Starting new thread...");
                                    MessageConsumerSession.this.startNewThread();
                                }
                                catch (Exception exception3222) {
                                    Configuration.logWarning((String)"MessageConsumerSession: Error starting new thread - stopping listener", (Exception)throwable2);
                                    MessageConsumerSession.this.stopListening();
                                }
                            }
                        }
                        if (!bl) continue;
                        messageConsumer = null;
                        this.close();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var7_10 = null;
                    try {
                        if (bl2) {
                            MessageConsumerSession.this.tm.commit();
                        } else {
                            MessageConsumerSession.this.tm.rollback();
                        }
                    }
                    catch (RollbackException throwable2) {
                        Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Exception)throwable2);
                    }
                    catch (HeuristicMixedException throwable2) {
                        Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Exception)throwable2);
                    }
                    catch (HeuristicRollbackException throwable2) {
                        Configuration.logDebug((String)"MessageConsumerSession: Error in ending transaction", (Exception)throwable2);
                    }
                    catch (Exception throwable2) {
                        Configuration.logWarning((String)"MessageConsumerSession: Error ending thread tx association", (Exception)throwable2);
                        try {
                            Configuration.logDebug((String)"MessageConsumerSession: Suspending any active transaction...");
                            MessageConsumerSession.this.tm.suspend();
                        }
                        catch (SystemException systemException2222) {
                            Configuration.logDebug((String)"MessageConsumerSession: Error suspending transaction", (Exception)((Object)systemException2222));
                            try {
                                Configuration.logDebug((String)"MessageConsumerSession: Starting new thread...");
                                MessageConsumerSession.this.startNewThread();
                            }
                            catch (Exception exception3222) {
                                Configuration.logWarning((String)"MessageConsumerSession: Error starting new thread - stopping listener", (Exception)throwable2);
                                MessageConsumerSession.this.stopListening();
                            }
                        }
                    }
                    if (bl) {
                        messageConsumer = null;
                        this.close();
                    }
                    throw throwable;
                }
            }
            Configuration.logInfo((String)"MessageConsumerSession: JMS listener thread exiting.");
            if (MessageConsumerSession.this.listener != null && MessageConsumerSession.this.current == null && MessageConsumerSession.this.notifyListenerOnClose) {
                MessageConsumerSession.this.listener.onMessage(null);
            }
        }
    }
}

