/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.xa.AbstractXidFactory;
import com.atomikos.datasource.xa.DefaultXidFactory;
import com.atomikos.datasource.xa.OraXidFactory;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.AbstractConnectionFactoryBean;
import com.atomikos.jms.JtaQueueConnectionFactory;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class QueueConnectionFactoryBean
extends AbstractConnectionFactoryBean
implements QueueConnectionFactory,
Externalizable {
    private transient JtaQueueConnectionFactory factory_ = null;
    private XAQueueConnectionFactory xaFactory_ = null;

    protected synchronized void checkSetup() throws JMSException {
        Object object;
        this.factory_ = JtaQueueConnectionFactory.getInstance(this.resourceName_);
        if (this.factory_ != null) {
            return;
        }
        AbstractXidFactory abstractXidFactory = null;
        abstractXidFactory = this.xidFactory_ == null || this.xidFactory_.equals("Default") ? new DefaultXidFactory() : new OraXidFactory();
        if (this.xaFactory_ == null && this.xaFactoryJndiName_.equals("")) {
            throw new JMSException("QueueConnectionFactoryBean: XAQueueConnectionFactory not set?");
        }
        if (!this.xaFactoryJndiName_.equals("")) {
            try {
                object = new InitialContext();
                Context context = (Context)object.lookup("java:comp/env");
                this.xaFactory_ = (XAQueueConnectionFactory)context.lookup(this.xaFactoryJndiName_);
            }
            catch (NamingException namingException) {
                throw new JMSException("QueueConnectionFactoryBean: error retrieving factory: " + namingException.getMessage());
            }
        }
        if (this.xidFactory_ == null && this.xaFactory_ != null && this.xaFactory_.getClass().getName().indexOf("oracle") >= 0) {
            abstractXidFactory = new OraXidFactory();
        }
        this.factory_ = JtaQueueConnectionFactory.getOrCreate(this.resourceName_, this.xaFactory_, abstractXidFactory);
        object = this.factory_.getTransactionalResource();
        if (Configuration.getResource((String)object.getName()) == null) {
            Configuration.addResource((RecoverableResource)object);
        }
    }

    public XAQueueConnectionFactory getXaQueueConnectionFactory() {
        return this.xaFactory_;
    }

    public void setXaQueueConnectionFactory(XAQueueConnectionFactory xAQueueConnectionFactory) {
        this.xaFactory_ = xAQueueConnectionFactory;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        this.checkSetup();
        return this.factory_.createQueueConnection();
    }

    public QueueConnection createQueueConnection(String string, String string2) throws JMSException {
        this.checkSetup();
        return this.factory_.createQueueConnection(string, string2);
    }

    public Connection createConnection() throws JMSException {
        return this.createQueueConnection();
    }

    public Connection createConnection(String string, String string2) throws JMSException {
        return this.createQueueConnection(string, string2);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.resourceName_);
        objectOutput.writeObject(this.xidFactory_);
        objectOutput.writeObject(this.xaFactory_);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.resourceName_ = (String)objectInput.readObject();
        this.xidFactory_ = (String)objectInput.readObject();
        try {
            this.xaFactory_ = (XAQueueConnectionFactory)objectInput.readObject();
        }
        catch (Exception exception) {
            System.err.println("Error reading XA Queue Bean");
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
    }
}

