/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.xa.AbstractXidFactory;
import com.atomikos.datasource.xa.DefaultXidFactory;
import com.atomikos.datasource.xa.OraXidFactory;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.AbstractConnectionFactoryBean;
import com.atomikos.jms.JtaTopicConnectionFactory;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class TopicConnectionFactoryBean
extends AbstractConnectionFactoryBean
implements TopicConnectionFactory {
    private transient JtaTopicConnectionFactory factory_;
    private XATopicConnectionFactory xaFactory_;

    protected synchronized void checkSetup() throws JMSException {
        Object object;
        this.factory_ = JtaTopicConnectionFactory.getInstance(this.resourceName_);
        if (this.factory_ != null) {
            return;
        }
        AbstractXidFactory abstractXidFactory = null;
        abstractXidFactory = this.xidFactory_ == null || this.xidFactory_.equals("Default") ? new DefaultXidFactory() : new OraXidFactory();
        if (this.xaFactory_ == null && "".equals(this.xaFactoryJndiName_)) {
            throw new JMSException("TopicConnectionFactoryBean: XATopicConnectionFactory not set?");
        }
        if (!"".equals(this.xaFactoryJndiName_)) {
            try {
                object = new InitialContext();
                Context context = (Context)object.lookup("java:comp/env");
                this.xaFactory_ = (XATopicConnectionFactory)context.lookup(this.xaFactoryJndiName_);
            }
            catch (NamingException namingException) {
                throw new JMSException("TopicConnectionFactoryBean: error retrieving factory: " + namingException.getMessage());
            }
        }
        if (this.xidFactory_ == null && this.xaFactory_ != null && this.xaFactory_.getClass().getName().indexOf("oracle") >= 0) {
            abstractXidFactory = new OraXidFactory();
        }
        this.factory_ = JtaTopicConnectionFactory.getOrCreate(this.resourceName_, this.xaFactory_, abstractXidFactory);
        object = this.factory_.getTransactionalResource();
        if (Configuration.getResource((String)object.getName()) == null) {
            Configuration.addResource((RecoverableResource)object);
        }
    }

    public void setXaTopicConnectionFactory(XATopicConnectionFactory xATopicConnectionFactory) {
        this.xaFactory_ = xATopicConnectionFactory;
    }

    public XATopicConnectionFactory getXaTopicConnectionFactory() {
        return this.xaFactory_;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        this.checkSetup();
        return this.factory_.createTopicConnection();
    }

    public TopicConnection createTopicConnection(String string, String string2) throws JMSException {
        this.checkSetup();
        return this.factory_.createTopicConnection(string, string2);
    }

    public Connection createConnection() throws JMSException {
        return this.createTopicConnection();
    }

    public Connection createConnection(String string, String string2) throws JMSException {
        return this.createTopicConnection(string, string2);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof TopicConnectionFactoryBean) {
            TopicConnectionFactoryBean topicConnectionFactoryBean = (TopicConnectionFactoryBean)object;
            bl = this.resourceName_ != null ? this.resourceName_.equals(topicConnectionFactoryBean.resourceName_) : super.equals(object);
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        n = this.resourceName_ != null ? this.resourceName_.hashCode() : super.hashCode();
        return n;
    }
}

