/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.templating;

import com.aventstack.extentreports.io.BufferedWriterWriter;
import com.aventstack.extentreports.templating.TemplateConfig;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class FreemarkerTemplate {
    private final TemplateConfig templateConfig = new TemplateConfig();
    private final Configuration freemarkerConfig;

    public FreemarkerTemplate(Configuration freemarkerConfiguration) {
        this.freemarkerConfig = freemarkerConfiguration;
    }

    public FreemarkerTemplate(Class<?> clazz, String encoding) {
        this.freemarkerConfig = this.templateConfig.getFreemarkerConfig(clazz, encoding);
    }

    public FreemarkerTemplate(Class<?> clazz, String basePackagePath, String encoding) {
        this.freemarkerConfig = this.templateConfig.getFreemarkerConfig(clazz, basePackagePath, encoding);
    }

    public Template createTemplate(String templatePath) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException {
        return this.freemarkerConfig.getTemplate(templatePath);
    }

    public String getSource(Template template, Map<String, Object> templateMap) throws TemplateException, IOException {
        return this.processTemplate(template, templateMap);
    }

    public void writeTemplate(Template template, Map<String, Object> templateMap, File outputFile) throws TemplateException, IOException {
        String source = this.getSource(template, templateMap);
        BufferedWriterWriter.getInstance().write(outputFile, source);
    }

    private String processTemplate(Template template, Map<String, Object> templateMap) throws TemplateException, IOException {
        StringWriter out = new StringWriter();
        template.process(templateMap, (Writer)out);
        String source = out.toString();
        out.close();
        return source;
    }
}

