/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.models;

import com.azure.messaging.servicebus.administration.implementation.models.MessageCountDetailsImpl;
import com.azure.messaging.servicebus.administration.models.SubscriptionProperties;
import java.time.OffsetDateTime;
import java.util.Objects;

public class SubscriptionRuntimeProperties {
    private final String subscriptionName;
    private final String topicName;
    private final long messageCount;
    private final OffsetDateTime accessedAt;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final int activeMessageCount;
    private final int deadLetterMessageCount;
    private final int transferDeadLetterMessageCount;
    private final int transferMessageCount;

    public SubscriptionRuntimeProperties(SubscriptionProperties subscriptionProperties) {
        Objects.requireNonNull(subscriptionProperties, "'subscriptionProperties' cannot be null.");
        this.subscriptionName = subscriptionProperties.getSubscriptionName();
        this.topicName = subscriptionProperties.getTopicName();
        this.messageCount = subscriptionProperties.getMessageCount();
        this.accessedAt = subscriptionProperties.getAccessedAt();
        this.createdAt = subscriptionProperties.getCreatedAt();
        this.updatedAt = subscriptionProperties.getUpdatedAt();
        MessageCountDetailsImpl details = subscriptionProperties.getMessageCountDetails();
        this.activeMessageCount = details != null ? details.getActiveMessageCount() : 0;
        this.deadLetterMessageCount = details != null ? details.getDeadLetterMessageCount() : 0;
        this.transferDeadLetterMessageCount = details != null ? details.getTransferDeadLetterMessageCount() : 0;
        this.transferMessageCount = details != null ? details.getTransferMessageCount() : 0;
    }

    public OffsetDateTime getAccessedAt() {
        return this.accessedAt;
    }

    public int getActiveMessageCount() {
        return this.activeMessageCount;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public int getDeadLetterMessageCount() {
        return this.deadLetterMessageCount;
    }

    public long getTotalMessageCount() {
        return this.messageCount;
    }

    public int getTransferDeadLetterMessageCount() {
        return this.transferDeadLetterMessageCount;
    }

    public int getTransferMessageCount() {
        return this.transferMessageCount;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }
}

