/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import com.azure.messaging.servicebus.implementation.ServiceBusConstants;
import com.azure.messaging.servicebus.implementation.ServiceBusDescribedType;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class OffsetDateTimeDescribedType
extends ServiceBusDescribedType {
    public OffsetDateTimeDescribedType(OffsetDateTime offsetDateTime) {
        super(ServiceBusConstants.OFFSETDATETIME_SYMBOL, OffsetDateTimeDescribedType.convertToTickTime(offsetDateTime));
    }

    private static Long convertToTickTime(OffsetDateTime offsetDateTime) {
        int nano = offsetDateTime.toInstant().atOffset(ZoneOffset.UTC).getNano();
        long seconds = offsetDateTime.toInstant().atOffset(ZoneOffset.UTC).toEpochSecond();
        return ServiceBusConstants.EPOCH_TICKS + seconds * ServiceBusConstants.TICK_PER_SECOND + (long)nano / ServiceBusConstants.TIME_LENGTH_DELTA;
    }

    @Override
    public int size() {
        return ServiceBusConstants.OFFSETDATETIME_SYMBOL.length() + 8;
    }
}

