/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography;

import com.azure.core.util.Base64Url;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.fasterxml.jackson.annotation.JsonProperty;

class KeyOperationParameters {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    @JsonProperty(value="alg", required=true)
    private EncryptionAlgorithm algorithm;
    @JsonProperty(value="value", required=true)
    private Base64Url value;
    @JsonProperty(value="iv")
    private Base64Url iv;
    @JsonProperty(value="aad")
    private Base64Url additionalAuthenticatedData;
    @JsonProperty(value="tag")
    private Base64Url authenticationTag;

    KeyOperationParameters() {
    }

    public EncryptionAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public KeyOperationParameters setAlgorithm(EncryptionAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public byte[] getValue() {
        if (this.value == null) {
            return EMPTY_ARRAY;
        }
        return this.value.decodedBytes();
    }

    public KeyOperationParameters setValue(byte[] value) {
        this.value = value != null ? Base64Url.encode((byte[])value) : null;
        return this;
    }

    public byte[] getIv() {
        if (this.iv == null) {
            return EMPTY_ARRAY;
        }
        return this.iv.decodedBytes();
    }

    public KeyOperationParameters setIv(byte[] iv) {
        this.iv = iv != null ? Base64Url.encode((byte[])iv) : null;
        return this;
    }

    public byte[] getAdditionalAuthenticatedData() {
        if (this.additionalAuthenticatedData == null) {
            return EMPTY_ARRAY;
        }
        return this.additionalAuthenticatedData.decodedBytes();
    }

    public KeyOperationParameters setAdditionalAuthenticatedData(byte[] additionalAuthenticatedData) {
        this.additionalAuthenticatedData = additionalAuthenticatedData != null ? Base64Url.encode((byte[])additionalAuthenticatedData) : null;
        return this;
    }

    public byte[] getAuthenticationTag() {
        if (this.authenticationTag == null) {
            return EMPTY_ARRAY;
        }
        return this.authenticationTag.decodedBytes();
    }

    public KeyOperationParameters setAuthenticationTag(byte[] authenticationTag) {
        this.authenticationTag = authenticationTag != null ? Base64Url.encode((byte[])authenticationTag) : null;
        return this;
    }
}

