/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.models;

import com.azure.security.keyvault.keys.implementation.KeyRotationLifetimeActionHelper;
import com.azure.security.keyvault.keys.implementation.KeyRotationPolicyHelper;
import com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicyAttributes;
import com.azure.security.keyvault.keys.implementation.models.LifetimeActions;
import com.azure.security.keyvault.keys.models.KeyRotationLifetimeAction;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

public final class KeyRotationPolicy {
    private final com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy impl;
    private List<KeyRotationLifetimeAction> lifetimeActions;

    public KeyRotationPolicy() {
        this(new com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy());
    }

    KeyRotationPolicy(com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy impl) {
        this.impl = impl;
    }

    public String getId() {
        return this.impl.getId();
    }

    public List<KeyRotationLifetimeAction> getLifetimeActions() {
        if (this.lifetimeActions == null && this.impl.getLifetimeActions() != null) {
            ArrayList<KeyRotationLifetimeAction> mappedActions = new ArrayList<KeyRotationLifetimeAction>(this.impl.getLifetimeActions().size());
            for (LifetimeActions action : this.impl.getLifetimeActions()) {
                KeyRotationLifetimeAction mappedAction = KeyRotationLifetimeActionHelper.createLifetimeAction(action.getTrigger(), action.getAction());
                mappedActions.add(mappedAction);
            }
            this.lifetimeActions = mappedActions;
        }
        return this.lifetimeActions;
    }

    public KeyRotationPolicy setLifetimeActions(List<KeyRotationLifetimeAction> lifetimeActions) {
        if (lifetimeActions == null) {
            this.lifetimeActions = null;
            this.impl.setLifetimeActions(null);
            return this;
        }
        ArrayList<LifetimeActions> mappedActions = new ArrayList<LifetimeActions>(lifetimeActions.size());
        for (KeyRotationLifetimeAction action : lifetimeActions) {
            mappedActions.add(new LifetimeActions().setAction(KeyRotationLifetimeActionHelper.getActionType(action)).setTrigger(KeyRotationLifetimeActionHelper.getTrigger(action)));
        }
        this.lifetimeActions = lifetimeActions;
        this.impl.setLifetimeActions(mappedActions);
        return this;
    }

    public String getExpiresIn() {
        return this.impl.getAttributes() == null ? null : this.impl.getAttributes().getExpiryTime();
    }

    public KeyRotationPolicy setExpiresIn(String expiresIn) {
        if (this.impl.getAttributes() == null) {
            this.impl.setAttributes(new KeyRotationPolicyAttributes());
        }
        this.impl.getAttributes().setExpiryTime(expiresIn);
        return this;
    }

    public OffsetDateTime getCreatedOn() {
        return this.impl.getAttributes() == null ? null : this.impl.getAttributes().getCreated();
    }

    public OffsetDateTime getUpdatedOn() {
        return this.impl.getAttributes() == null ? null : this.impl.getAttributes().getUpdated();
    }

    static {
        KeyRotationPolicyHelper.setAccessor(new KeyRotationPolicyHelper.KeyRotationPolicyAccessor(){

            @Override
            public KeyRotationPolicy createPolicy(com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy impl) {
                return new KeyRotationPolicy(impl);
            }

            @Override
            public com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy getImpl(KeyRotationPolicy policy) {
                return policy.impl;
            }
        });
    }
}

