/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import java.util.logging.Logger;
import org.openqa.selenium.remote.DesiredCapabilities;

public class Configuration {
    private static final Logger LOG = Logger.getLogger(Configuration.class.getName());
    public static String baseUrl = System.getProperty("selenide.baseUrl", "http://localhost:8080");
    public static long collectionsTimeout = Long.parseLong(System.getProperty("selenide.collectionsTimeout", "6000"));
    public static long timeout = Long.parseLong(System.getProperty("selenide.timeout", "4000"));
    public static long pollingInterval = Long.parseLong(System.getProperty("selenide.pollingInterval", "100"));
    public static long collectionsPollingInterval = Long.parseLong(System.getProperty("selenide.collectionsPollingInterval", "200"));
    public static boolean holdBrowserOpen = Boolean.getBoolean("selenide.holdBrowserOpen");
    public static boolean reopenBrowserOnFail = Boolean.parseBoolean(System.getProperty("selenide.reopenBrowserOnFail", "true"));
    public static long openBrowserTimeoutMs = Long.parseLong(System.getProperty("selenide.openBrowserTimeout", "15000"));
    public static long closeBrowserTimeoutMs = Long.parseLong(System.getProperty("selenide.closeBrowserTimeout", "5000"));
    public static String browser = System.getProperty("selenide.browser", System.getProperty("browser", "firefox"));
    public static String browserVersion = System.getProperty("selenide.browserVersion", System.getProperty("selenide.browser.version", System.getProperty("browser.version")));
    public static String remote = System.getProperty("remote");
    public static String browserSize = System.getProperty("selenide.browserSize", System.getProperty("selenide.browser-size"));
    public static boolean startMaximized = Boolean.parseBoolean(System.getProperty("selenide.startMaximized", System.getProperty("selenide.start-maximized", "true")));
    @Deprecated
    public static String chromeSwitches = System.getProperty("selenide.chrome.switches", System.getProperty("chrome.switches"));
    public static DesiredCapabilities browserCapabilities;
    public static String pageLoadStrategy;
    public static boolean clickViaJs;
    public static boolean captureJavascriptErrors;
    public static boolean screenshots;
    public static boolean savePageSource;
    public static String reportsFolder;
    public static String reportsUrl;
    public static boolean dismissModalDialogs;
    public static boolean fastSetValue;
    public static boolean versatileSetValue;
    public static SelectorMode selectorMode;
    public static AssertionMode assertionMode;
    public static FileDownloadMode fileDownload;
    public static boolean driverManagerEnabled;
    public static boolean headless;
    public static String browserBinary;

    static String getReportsUrl() {
        String reportsUrl = System.getProperty("selenide.reportsUrl");
        if (Configuration.isEmpty(reportsUrl)) {
            reportsUrl = Configuration.getJenkinsReportsUrl();
            if (Configuration.isEmpty(reportsUrl)) {
                LOG.config("Variable selenide.reportsUrl not found");
            }
        } else {
            LOG.config("Using variable selenide.reportsUrl=" + reportsUrl);
        }
        return reportsUrl;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    private static String getJenkinsReportsUrl() {
        String build_url = System.getProperty("BUILD_URL");
        if (!Configuration.isEmpty(build_url)) {
            LOG.config("Using Jenkins BUILD_URL: " + build_url);
            return build_url + "artifact/";
        }
        LOG.config("No BUILD_URL variable found. It's not Jenkins.");
        return null;
    }

    static {
        pageLoadStrategy = System.getProperty("selenide.pageLoadStrategy", System.getProperty("selenide.page-load-strategy", "normal"));
        clickViaJs = Boolean.parseBoolean(System.getProperty("selenide.clickViaJs", System.getProperty("selenide.click-via-js", "false")));
        captureJavascriptErrors = Boolean.parseBoolean(System.getProperty("selenide.captureJavascriptErrors", "true"));
        screenshots = Boolean.parseBoolean(System.getProperty("selenide.screenshots", "true"));
        savePageSource = Boolean.parseBoolean(System.getProperty("selenide.savePageSource", "true"));
        reportsFolder = System.getProperty("selenide.reportsFolder", System.getProperty("selenide.reports", "build/reports/tests"));
        reportsUrl = Configuration.getReportsUrl();
        dismissModalDialogs = Boolean.parseBoolean(System.getProperty("selenide.dismissModalDialogs", "false"));
        fastSetValue = Boolean.parseBoolean(System.getProperty("selenide.fastSetValue", "false"));
        versatileSetValue = Boolean.parseBoolean(System.getProperty("selenide.versatileSetValue", "false"));
        selectorMode = SelectorMode.CSS;
        assertionMode = AssertionMode.STRICT;
        fileDownload = FileDownloadMode.valueOf(System.getProperty("selenide.fileDownload", FileDownloadMode.HTTPGET.name()));
        driverManagerEnabled = Boolean.parseBoolean(System.getProperty("selenide.driverManagerEnabled", "true"));
        headless = Boolean.parseBoolean(System.getProperty("selenide.headless", "false"));
        browserBinary = System.getProperty("selenide.browserBinary", "");
    }

    public static enum FileDownloadMode {
        HTTPGET,
        PROXY;

    }

    public static enum AssertionMode {
        STRICT,
        SOFT;

    }

    public static enum SelectorMode {
        CSS,
        Sizzle;

    }
}

