/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.WebElementSource;
import org.openqa.selenium.WebElement;

public class Click
implements Command<Void> {
    @Override
    public Void execute(SelenideElement proxy, WebElementSource locator, Object[] args) {
        if (args == null || args.length == 0) {
            this.click(locator.findAndAssertElementIsVisible());
        } else if (args.length == 2) {
            this.click(locator.findAndAssertElementIsVisible(), (Integer)args[0], (Integer)args[1]);
        }
        return null;
    }

    protected void click(WebElement element) {
        if (Configuration.clickViaJs) {
            Selenide.executeJavaScript("arguments[0].click()", element);
        } else {
            element.click();
        }
    }

    protected void click(WebElement element, int offsetX, int offsetY) {
        if (Configuration.clickViaJs) {
            Selenide.executeJavaScript("arguments[0].dispatchEvent(new MouseEvent('click', {'view': window,'bubbles': true,'cancelable': true,'clientX': arguments[0].getClientRects()[0].left + arguments[1],'clientY': arguments[0].getClientRects()[0].top + arguments[2]}))", element, offsetX, offsetY);
        } else {
            Selenide.actions().moveToElement(element, offsetX, offsetY).click().build().perform();
        }
    }
}

