/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.DownloadFileWithHttpRequest;
import com.codeborne.selenide.impl.DownloadFileWithProxyServer;
import com.codeborne.selenide.impl.WebElementSource;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.openqa.selenium.WebElement;

public class DownloadFile
implements Command<File> {
    private static final Logger LOG = Logger.getLogger(DownloadFile.class.getName());
    DownloadFileWithHttpRequest downloadFileWithHttpRequest = new DownloadFileWithHttpRequest();
    DownloadFileWithProxyServer downloadFileWithProxyServer = new DownloadFileWithProxyServer();

    @Override
    public File execute(SelenideElement proxy, WebElementSource linkWithHref, Object[] args) throws IOException {
        WebElement link = linkWithHref.findAndAssertElementIsVisible();
        if (Configuration.fileDownload == Configuration.FileDownloadMode.HTTPGET) {
            LOG.config("selenide.fileDownload = " + System.getProperty("selenide.fileDownload") + " download file via http get");
            return this.downloadFileWithHttpRequest.download(link);
        }
        if (WebDriverRunner.webdriverContainer.getProxyServer() == null) {
            LOG.config("Proxy server is not started - download file via http get");
            return this.downloadFileWithHttpRequest.download(link);
        }
        return this.downloadFileWithProxyServer.download(linkWithHref, link, WebDriverRunner.webdriverContainer.getProxyServer());
    }
}

