/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.commands.SelectOptionByValue;
import com.codeborne.selenide.commands.SelectRadio;
import com.codeborne.selenide.ex.InvalidStateException;
import com.codeborne.selenide.impl.Events;
import com.codeborne.selenide.impl.WebElementSource;
import org.openqa.selenium.WebElement;

public class SetValue
implements Command<WebElement> {
    SelectOptionByValue selectOptionByValue = new SelectOptionByValue();
    SelectRadio selectRadio = new SelectRadio();

    @Override
    public WebElement execute(SelenideElement proxy, WebElementSource locator, Object[] args) {
        String text = (String)args[0];
        WebElement element = locator.findAndAssertElementIsVisible();
        if (Configuration.versatileSetValue && "select".equalsIgnoreCase(element.getTagName())) {
            this.selectOptionByValue.execute(proxy, locator, args);
            return proxy;
        }
        if (Configuration.versatileSetValue && "input".equalsIgnoreCase(element.getTagName()) && "radio".equals(element.getAttribute("type"))) {
            this.selectRadio.execute(proxy, locator, args);
            return proxy;
        }
        this.setValueForTextInput(element, text);
        return proxy;
    }

    private void setValueForTextInput(WebElement element, String text) {
        if (text == null || text.isEmpty()) {
            element.clear();
        } else if (Configuration.fastSetValue) {
            String error = this.setValueByJs(element, text);
            if (error != null) {
                throw new InvalidStateException(error);
            }
            Events.events.fireEvent(element, "keydown", "keypress", "input", "keyup", "change");
        } else {
            element.clear();
            element.sendKeys(new CharSequence[]{text});
            Events.events.fireChangeEvent(element);
        }
    }

    private String setValueByJs(WebElement element, String text) {
        return (String)Selenide.executeJavaScript("return (function(webelement, text) {if (webelement.getAttribute('readonly') != undefined) return 'Cannot change value of readonly element';if (webelement.getAttribute('disabled') != undefined) return 'Cannot change value of disabled element';webelement.focus();var maxlength = webelement.getAttribute('maxlength') == null ? -1 : parseInt(webelement.getAttribute('maxlength'));webelement.value = maxlength == -1 ? text : text.length <= maxlength ? text : text.substring(0, maxlength);return null;})(arguments[0], arguments[1]);", element, text);
    }
}

