/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.ex;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Screenshots;
import com.codeborne.selenide.impl.Cleanup;
import java.util.List;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class ErrorMessages {
    protected static String timeout(long timeoutMs) {
        if (timeoutMs < 1000L) {
            return "\nTimeout: " + timeoutMs + " ms.";
        }
        if (timeoutMs % 1000L == 0L) {
            return "\nTimeout: " + timeoutMs / 1000L + " s.";
        }
        return "\nTimeout: " + String.format("%.3f", (double)timeoutMs / 1000.0) + " s.";
    }

    public static String actualValue(Condition condition, WebElement element) {
        String actualValue;
        if (element != null && (actualValue = condition.actualValue(element)) != null) {
            return "\nActual value: " + actualValue;
        }
        return "";
    }

    public static String screenshot() {
        return ErrorMessages.screenshot(Screenshots.screenshots.formatScreenShotPath());
    }

    public static String screenshot(String screenshotPath) {
        if (!Configuration.screenshots) {
            return "";
        }
        if (screenshotPath == null || screenshotPath.isEmpty()) {
            return "\nScreenshot: " + screenshotPath;
        }
        if (Configuration.savePageSource) {
            String htmlFilePath = ErrorMessages.getHtmlFilePath(screenshotPath);
            return "\nScreenshot: " + screenshotPath + "\nPage source: " + htmlFilePath;
        }
        return "\nScreenshot: " + screenshotPath;
    }

    public static String causedBy(Throwable cause) {
        if (cause == null) {
            return "";
        }
        if (cause instanceof WebDriverException) {
            return "\nCaused by: " + Cleanup.of.webdriverExceptionMessage(cause);
        }
        return "\nCaused by: " + cause;
    }

    public static String jsErrors(List<String> jsErrors) {
        if (jsErrors == null || jsErrors.isEmpty()) {
            return "";
        }
        return "\nJavascript Errors: " + jsErrors;
    }

    private static String getHtmlFilePath(String screenshotPath) {
        return screenshotPath.substring(0, screenshotPath.lastIndexOf(46)) + ".html";
    }
}

