/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.ui.CN;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Form;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.LayeredLayout;
import com.codename1.ui.layouts.Layout;
import com.codename1.ui.plaf.Border;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;

public class InteractionDialog
extends Container {
    private final Label title = new Label();
    private final Container titleArea = new Container(new BorderLayout());
    private final Container contentPane;
    private boolean animateShow = true;
    private boolean repositionAnimation = true;
    private boolean disposed;
    private boolean disposeWhenPointerOutOfBounds;
    private boolean formMode;
    private boolean pressedOutOfBounds;
    private ActionListener pressedListener;
    private ActionListener releasedListener;

    public InteractionDialog() {
        super(new BorderLayout());
        this.contentPane = new Container();
        this.init();
    }

    public InteractionDialog(Layout l) {
        super(new BorderLayout());
        this.contentPane = new Container(l);
        this.init();
    }

    public InteractionDialog(String title) {
        super(new BorderLayout());
        this.contentPane = new Container();
        this.title.setText(title);
        this.init();
    }

    public InteractionDialog(String title, Layout l) {
        super(new BorderLayout());
        this.contentPane = new Container(l);
        this.title.setText(title);
        this.init();
    }

    private void init() {
        this.setUIID("Dialog");
        this.title.setUIID("DialogTitle");
        this.contentPane.setUIID("DialogContentPane");
        super.addComponent("North", (Component)this.titleArea);
        this.titleArea.addComponent("Center", (Component)this.title);
        super.addComponent("Center", (Component)this.contentPane);
        this.setGrabsPointerEvents(true);
    }

    protected void initComponent() {
        super.initComponent();
        this.installPointerOutOfBoundsListeners();
    }

    public void setDisposeWhenPointerOutOfBounds(boolean disposeWhenPointerOutOfBounds) {
        this.disposeWhenPointerOutOfBounds = disposeWhenPointerOutOfBounds;
    }

    public boolean isDisposeWhenPointerOutOfBounds() {
        return this.disposeWhenPointerOutOfBounds;
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public void setScrollable(boolean scrollable) {
        this.getContentPane().setScrollable(scrollable);
    }

    public Layout getLayout() {
        return this.contentPane.getLayout();
    }

    public String getTitle() {
        return this.title.getText();
    }

    public void addComponent(Component cmp) {
        this.contentPane.addComponent(cmp);
    }

    public void addComponent(Object constraints, Component cmp) {
        this.contentPane.addComponent(constraints, cmp);
    }

    public void addComponent(int index, Object constraints, Component cmp) {
        this.contentPane.addComponent(index, constraints, cmp);
    }

    public void addComponent(int index, Component cmp) {
        this.contentPane.addComponent(index, cmp);
    }

    public void removeAll() {
        this.contentPane.removeAll();
    }

    public void removeComponent(Component cmp) {
        this.contentPane.removeComponent(cmp);
    }

    public Label getTitleComponent() {
        return this.title;
    }

    public void setLayout(Layout layout) {
        this.contentPane.setLayout(layout);
    }

    public void setTitle(String title) {
        this.title.setText(title);
    }

    private void cleanupLayer(Form f) {
        if (this.formMode) {
            Container c = f.getFormLayeredPane(InteractionDialog.class, true);
            c.removeAll();
            c.remove();
        }
    }

    private Container getLayeredPane(Form f) {
        Container c = this.formMode ? f.getFormLayeredPane(InteractionDialog.class, true) : f.getLayeredPane(InteractionDialog.class, true);
        if (!(c.getLayout() instanceof LayeredLayout)) {
            c.setLayout(new LayeredLayout());
        }
        return c;
    }

    protected void deinitialize() {
        Form f;
        super.deinitialize();
        if (this.disposed && (f = this.getComponentForm()) != null) {
            if (this.pressedListener != null) {
                f.removePointerPressedListener(this.pressedListener);
            }
            if (this.releasedListener != null) {
                f.removePointerReleasedListener(this.releasedListener);
            }
            Container pp = this.getLayeredPane(f);
            Container p = this.getParent();
            this.remove();
            if (p.getComponentCount() == 0) {
                p.remove();
            }
            pp.revalidateLater();
            this.cleanupLayer(f);
        }
    }

    public void resize(int top, int bottom, int left, int right) {
        if (!this.disposed) {
            Form f = Display.getInstance().getCurrent();
            Style unselectedStyle = this.getUnselectedStyle();
            unselectedStyle.setMargin(0, Math.max(0, top));
            unselectedStyle.setMargin(2, Math.max(0, bottom));
            unselectedStyle.setMargin(1, Math.max(0, left));
            unselectedStyle.setMargin(3, Math.max(0, right));
            unselectedStyle.setMarginUnit(0, 0, 0, 0);
            this.getParent().setX(this.getX());
            this.getParent().setY(this.getY());
            this.setX(0);
            this.setY(0);
            this.getParent().setWidth(this.getWidth());
            this.getParent().setHeight(this.getHeight());
            this.getLayeredPane(f).animateLayout(this.getUIManager().getThemeConstant("interactionDialogSpeedInt", 400));
        }
    }

    public void show(int top, int bottom, int left, int right) {
        this.getUnselectedStyle().setOpacity(255);
        this.disposed = false;
        Form f = Display.getInstance().getCurrent();
        Style unselectedStyle = this.getUnselectedStyle();
        unselectedStyle.setMargin(0, top);
        unselectedStyle.setMargin(2, bottom);
        unselectedStyle.setMargin(1, left);
        unselectedStyle.setMargin(3, right);
        unselectedStyle.setMarginUnit(0, 0, 0, 0);
        this.remove();
        this.getLayeredPane(f).revalidate();
        this.getLayeredPane(f).addComponent(BorderLayout.center(this));
        if (this.animateShow) {
            int x = left + (f.getWidth() - right - left) / 2;
            int y = top + (f.getHeight() - bottom - top) / 2;
            if (this.repositionAnimation) {
                this.getParent().setX(x);
                this.getParent().setY(y);
                this.getParent().setWidth(1);
                this.getParent().setHeight(1);
            } else {
                this.getParent().setX(this.getX());
                this.getParent().setY(this.getY());
                this.setX(0);
                this.setY(0);
                this.getParent().setWidth(this.getWidth());
                this.getParent().setHeight(this.getHeight());
            }
            this.getLayeredPane(f).animateLayout(this.getUIManager().getThemeConstant("interactionDialogSpeedInt", 400));
        } else {
            f.revalidateWithAnimationSafety();
        }
    }

    public void dispose() {
        this.disposed = true;
        Container p = this.getParent();
        if (p != null) {
            Form f = p.getComponentForm();
            if (f != null) {
                if (this.animateShow) {
                    if (this.repositionAnimation) {
                        this.setX(this.getX() + this.getWidth() / 2);
                        this.setY(this.getY() + this.getHeight() / 2);
                        this.setWidth(1);
                        this.setHeight(1);
                    }
                    p.animateUnlayoutAndWait(this.getUIManager().getThemeConstant("interactionDialogSpeedInt", 400), 100);
                }
                Container pp = this.getLayeredPane(f);
                this.remove();
                if (p.getComponentCount() == 0) {
                    p.remove();
                }
                pp.revalidate();
                this.cleanupLayer(f);
            } else {
                p.remove();
            }
        }
    }

    public void disposeToTheLeft() {
        this.disposeTo(1);
    }

    public void disposeToTheBottom() {
        this.disposeTo(2);
    }

    public void disposeToTheBottom(Runnable onFinish) {
        this.disposeTo(2, onFinish);
    }

    public void disposeToTheTop() {
        this.disposeTo(0);
    }

    public void disposeToTheRight() {
        this.disposeTo(3);
    }

    private void disposeTo(int direction) {
        this.disposeTo(direction, null);
    }

    private void disposeTo(int direction, final Runnable onFinish) {
        this.disposed = true;
        final Container p = this.getParent();
        if (p != null) {
            final Form f = p.getComponentForm();
            if (f != null) {
                switch (direction) {
                    case 1: {
                        this.setX(-this.getWidth());
                        break;
                    }
                    case 0: {
                        this.setY(-this.getHeight());
                        break;
                    }
                    case 3: {
                        this.setX(Display.getInstance().getDisplayWidth());
                        break;
                    }
                    case 2: {
                        this.setY(Display.getInstance().getDisplayHeight());
                    }
                }
                if (this.animateShow) {
                    p.animateUnlayout(this.getUIManager().getThemeConstant("interactionDialogSpeedInt", 400), 255, new Runnable(){

                        public void run() {
                            if (p.getParent() != null) {
                                Container pp = InteractionDialog.this.getLayeredPane(f);
                                InteractionDialog.this.remove();
                                p.remove();
                                pp.removeAll();
                                pp.revalidate();
                                InteractionDialog.this.cleanupLayer(f);
                            }
                            if (onFinish != null) {
                                onFinish.run();
                            }
                        }
                    });
                } else {
                    p.revalidate();
                    Container pp = this.getLayeredPane(f);
                    this.remove();
                    p.remove();
                    pp.removeAll();
                    pp.revalidate();
                    if (onFinish != null) {
                        onFinish.run();
                    }
                }
            } else {
                this.remove();
                if (onFinish != null) {
                    onFinish.run();
                }
            }
        }
    }

    public boolean isShowing() {
        return this.getParent() != null;
    }

    public boolean isAnimateShow() {
        return this.animateShow;
    }

    public void setAnimateShow(boolean animateShow) {
        this.animateShow = animateShow;
    }

    private void installPointerOutOfBoundsListeners() {
        final Form f = this.getComponentForm();
        if (f != null) {
            if (this.pressedListener == null) {
                this.pressedListener = new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        if (InteractionDialog.this.disposed) {
                            f.removePointerPressedListener(InteractionDialog.this.pressedListener);
                            f.removePointerReleasedListener(InteractionDialog.this.releasedListener);
                            return;
                        }
                        InteractionDialog.this.pressedOutOfBounds = InteractionDialog.this.disposeWhenPointerOutOfBounds && !InteractionDialog.this.getContentPane().containsOrOwns(evt.getX(), evt.getY()) && !InteractionDialog.this.getTitleComponent().containsOrOwns(evt.getX(), evt.getY());
                        if (InteractionDialog.this.pressedOutOfBounds && InteractionDialog.this.disposeWhenPointerOutOfBounds) {
                            evt.consume();
                        }
                    }
                };
            }
            if (this.releasedListener == null) {
                this.releasedListener = new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        if (InteractionDialog.this.disposed) {
                            f.removePointerPressedListener(InteractionDialog.this.pressedListener);
                            f.removePointerReleasedListener(InteractionDialog.this.releasedListener);
                            return;
                        }
                        if (InteractionDialog.this.disposeWhenPointerOutOfBounds && InteractionDialog.this.pressedOutOfBounds && !InteractionDialog.this.getContentPane().containsOrOwns(evt.getX(), evt.getY()) && !InteractionDialog.this.getTitleComponent().containsOrOwns(evt.getX(), evt.getY())) {
                            evt.consume();
                            f.removePointerPressedListener(InteractionDialog.this.pressedListener);
                            f.removePointerReleasedListener(InteractionDialog.this.releasedListener);
                            InteractionDialog.this.dispose();
                        }
                    }
                };
            }
            f.addPointerPressedListener(this.pressedListener);
            f.addPointerReleasedListener(this.releasedListener);
        }
    }

    public void showPopupDialog(Component c) {
        this.showPopupDialog(c, Display.getInstance().isPortrait());
    }

    public void showPopupDialog(Component c, boolean bias) {
        Form f;
        Form form = f = c == null ? null : c.getComponentForm();
        if (f != null && !this.formMode && !f.getContentPane().contains(c)) {
            this.setFormMode(true);
        }
        this.disposed = false;
        this.getUnselectedStyle().setOpacity(255);
        Rectangle componentPos = c.getSelectedRect();
        componentPos.setX(componentPos.getX() - c.getScrollX());
        componentPos.setY(componentPos.getY() - c.getScrollY());
        this.setOwner(c);
        this.showPopupDialog(componentPos, bias);
    }

    public void showPopupDialog(Rectangle rect) {
        this.showPopupDialog(rect, Display.getInstance().isPortrait());
    }

    public void showPopupDialog(Rectangle rect, boolean bias) {
        int availableWidth;
        int availableHeight;
        Form f = Display.getInstance().getCurrent();
        Rectangle origRect = rect;
        rect = new Rectangle(rect);
        rect.setX(rect.getX() - this.getLayeredPane(f).getAbsoluteX());
        rect.setY(rect.getY() - this.getLayeredPane(f).getAbsoluteY());
        this.disposed = false;
        this.pressedOutOfBounds = false;
        this.getUnselectedStyle().setOpacity(255);
        if (this.getUIID().equals("Dialog")) {
            this.setUIID("PopupDialog");
            if (this.getTitleComponent().getUIID().equals("DialogTitle")) {
                this.getTitleComponent().setUIID("PopupDialogTitle");
            }
            this.getContentPane().setUIID("PopupContentPane");
        }
        Container contentPane = this.getContentPane();
        Label title = this.getTitleComponent();
        UIManager manager = this.getUIManager();
        String dialogTitle = title.getText();
        if ((dialogTitle != null || dialogTitle.length() == 0) && manager.isThemeConstant("hideEmptyTitleBool", true)) {
            boolean b = this.getTitle().length() > 0;
            this.titleArea.setVisible(b);
            this.getTitleComponent().setVisible(b);
            if (!b && manager.isThemeConstant("shrinkPopupTitleBool", true)) {
                this.getTitleComponent().setPreferredSize(new Dimension(0, 0));
                this.getTitleComponent().getStyle().setBorder(null);
                this.titleArea.setPreferredSize(new Dimension(0, 0));
            }
        }
        this.revalidate();
        Style contentPaneStyle = this.getStyle();
        boolean restoreArrow = false;
        if (manager.isThemeConstant(this.getUIID() + "ArrowBool", false)) {
            Image t = manager.getThemeImageConstant(this.getUIID() + "ArrowTopImage");
            Image b = manager.getThemeImageConstant(this.getUIID() + "ArrowBottomImage");
            Image l = manager.getThemeImageConstant(this.getUIID() + "ArrowLeftImage");
            Image r = manager.getThemeImageConstant(this.getUIID() + "ArrowRightImage");
            Border border = contentPaneStyle.getBorder();
            if (border != null) {
                border.setImageBorderSpecialTile(t, b, l, r, rect);
                restoreArrow = true;
            }
        } else {
            Border border = contentPaneStyle.getBorder();
            if (border != null) {
                border.setTrackComponent(origRect);
            }
        }
        this.calcPreferredSize();
        int prefHeight = this.getPreferredH();
        int prefWidth = this.getPreferredW();
        if (contentPaneStyle.getBorder() != null) {
            prefWidth = Math.max(contentPaneStyle.getBorder().getMinimumWidth(), prefWidth);
            prefHeight = Math.max(contentPaneStyle.getBorder().getMinimumHeight(), prefHeight);
        }
        if ((availableHeight = this.getLayeredPane(f).getParent().getHeight()) == 0) {
            availableHeight = CN.getDisplayHeight();
        }
        if ((availableWidth = this.getLayeredPane(f).getParent().getWidth()) == 0) {
            availableWidth = CN.getDisplayWidth();
        }
        int width = Math.min(availableWidth, prefWidth);
        this.setWidth(width);
        this.setShouldCalcPreferredSize(true);
        this.revalidate();
        prefHeight = this.getPreferredH();
        int x = 0;
        int y = 0;
        boolean showPortrait = bias;
        if (showPortrait) {
            if (availableHeight < (availableWidth - rect.getWidth()) / 2) {
                showPortrait = false;
            }
        } else if (availableHeight / 2 > availableWidth - rect.getWidth()) {
            showPortrait = true;
        }
        if (showPortrait) {
            int height;
            int idealX;
            if (width < availableWidth && (idealX = rect.getX() - width / 2 + rect.getSize().getWidth() / 2) > 0) {
                x = idealX + width > availableWidth ? availableWidth - width : idealX;
            }
            if (rect.getY() + rect.getHeight() < availableHeight / 2) {
                y = rect.getY() + rect.getHeight();
                height = Math.min(prefHeight, Math.max(0, availableHeight - y));
                this.padOrientation(contentPaneStyle, 0, 1);
                this.show(Math.max(0, y), Math.max(0, availableHeight - height - y), Math.max(0, x), Math.max(0, availableWidth - width - x));
                this.padOrientation(contentPaneStyle, 0, -1);
            } else if (rect.getY() > availableHeight / 2) {
                height = Math.min(prefHeight, rect.getY());
                y = rect.getY() - height;
                this.padOrientation(contentPaneStyle, 2, 1);
                this.show(y, Math.max(0, availableHeight - rect.getY()), x, Math.max(0, availableWidth - width - x));
                this.padOrientation(contentPaneStyle, 2, -1);
            } else if (rect.getY() < availableHeight / 2) {
                y = rect.getY() + CN.convertToPixels(3.0f);
                height = Math.min(prefHeight, availableHeight - y);
                this.padOrientation(contentPaneStyle, 2, 1);
                this.show(y, Math.max(0, availableHeight - height - y), Math.max(0, x), Math.max(0, availableWidth - width - x));
                this.padOrientation(contentPaneStyle, 2, -1);
            } else {
                y = Math.max(0, rect.getY() + rect.getHeight() - CN.convertToPixels(3.0f) - prefHeight);
                height = prefHeight;
                this.padOrientation(contentPaneStyle, 0, 1);
                this.show(y, Math.max(0, availableHeight - height - y), Math.max(0, x), Math.max(0, availableWidth - width - x));
                this.padOrientation(contentPaneStyle, 0, -1);
            }
        } else {
            int idealY;
            int height = Math.min(prefHeight, availableHeight);
            if (height < availableHeight && (idealY = rect.getY() - height / 2 + rect.getSize().getHeight() / 2) > 0) {
                y = idealY + height > availableHeight ? availableHeight - height : idealY;
            }
            if (prefWidth < availableWidth - rect.getX() - rect.getWidth()) {
                x = rect.getX() + rect.getWidth();
                width = Math.min(prefWidth, availableWidth - x);
                this.show(y, availableHeight - height - y, Math.max(0, x), Math.max(0, availableWidth - width - x));
            } else if (prefWidth < rect.getX()) {
                x = rect.getX() - prefWidth;
                width = prefWidth;
                this.show(y, availableHeight - height - y, Math.max(0, x), Math.max(0, availableWidth - width - x));
            } else {
                width = Math.min(prefWidth, availableWidth - (availableWidth - rect.getX()));
                x = rect.getX() - width;
                this.show(y, availableHeight - height - y, Math.max(0, x), Math.max(0, availableWidth - width - x));
            }
        }
    }

    private void padOrientation(Style s, int orientation, int padding) {
        byte unit;
        byte[] b = s.getPaddingUnit();
        byte by = unit = b == null ? (byte)0 : s.getPaddingUnit()[orientation];
        if (unit != 2) {
            padding = Display.getInstance().convertToPixels(padding);
        }
        s.setPadding(orientation, s.getPaddingValue(this.isRTL(), orientation) + padding);
    }

    public void setDialogUIID(String uiid) {
        this.getContentPane().setUIID(uiid);
    }

    public String getDialogUIID() {
        return this.getContentPane().getUIID();
    }

    public Style getDialogStyle() {
        return this.getContentPane().getStyle();
    }

    public boolean isRepositionAnimation() {
        return this.repositionAnimation;
    }

    public void setRepositionAnimation(boolean repositionAnimation) {
        this.repositionAnimation = repositionAnimation;
    }

    public boolean isFormMode() {
        return this.formMode;
    }

    public void setFormMode(boolean formMode) {
        this.formMode = formMode;
    }
}

