/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.io;

import com.codename1.io.File;
import com.codename1.io.FileSystemStorage;
import com.codename1.io.Log;
import com.codename1.io.Storage;
import com.codename1.io.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public interface Data {
    public void appendTo(OutputStream var1) throws IOException;

    public long getSize() throws IOException;

    public static class ByteData
    implements Data {
        private byte[] bytes;

        public ByteData(byte[] bytes) {
            this.bytes = bytes;
        }

        public void appendTo(OutputStream output) throws IOException {
            output.write(this.bytes);
        }

        public long getSize() throws IOException {
            return this.bytes.length;
        }
    }

    public static class StorageData
    implements Data {
        private String key;

        public StorageData(String key) {
            this.key = key;
        }

        public void appendTo(OutputStream output) throws IOException {
            Util.copyNoClose(Storage.getInstance().createInputStream(this.key), output, 8192);
        }

        public long getSize() throws IOException {
            return Storage.getInstance().entrySize(this.key);
        }
    }

    public static class FileData
    implements Data {
        private File file;

        public FileData(File file) {
            this.file = file;
        }

        public void appendTo(OutputStream output) throws IOException {
            FileSystemStorage fs = FileSystemStorage.getInstance();
            Util.copyNoClose(fs.openInputStream(this.file.getAbsolutePath()), output, 8192);
        }

        public long getSize() throws IOException {
            return this.file.length();
        }
    }

    public static class StringData
    implements Data {
        private byte[] bytes;

        public StringData(String str) {
            this(str, "UTF-8");
        }

        public StringData(String str, String charset) {
            try {
                this.bytes = str.getBytes(charset);
            }
            catch (UnsupportedEncodingException ex) {
                Log.e(ex);
                throw new RuntimeException("Failed to create StringData with encoding " + charset);
            }
        }

        public void appendTo(OutputStream output) throws IOException {
            output.write(this.bytes);
        }

        public long getSize() throws IOException {
            return this.bytes.length;
        }
    }
}

