/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.spinner;

import com.codename1.impl.CodenameOneImplementation;
import com.codename1.ui.Component;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.list.DefaultListModel;
import com.codename1.ui.list.ListCellRenderer;
import com.codename1.ui.list.ListModel;
import com.codename1.ui.spinner.BaseSpinner;
import com.codename1.ui.spinner.Spinner;
import com.codename1.ui.spinner.SpinnerRenderer;

public class GenericSpinner
extends BaseSpinner {
    private Spinner[] spin;
    private ListModel[] model = new ListModel[]{new DefaultListModel<Object>("Value 1", "Value 2", "Value 3")};
    private ListCellRenderer[] renderer = new ListCellRenderer[]{new SpinnerRenderer()};
    private Object[] value;
    private String[] renderingPrototype;

    public GenericSpinner() {
        SpinnerRenderer render = (SpinnerRenderer)this.renderer[0];
        render.setShowNumbers(false);
        render.setUIID("SpinnerRenderer");
    }

    void initSpinner() {
        if (this.spin == null) {
            if (this.model.length == 1) {
                this.spin = new Spinner[]{this.createSpinner(0)};
                if (this.renderingPrototype != null) {
                    this.spin[0].setRenderingPrototype(this.renderingPrototype[0]);
                }
                this.setLayout(new BorderLayout());
                this.addComponent("Center", (Component)this.spin[0]);
            } else {
                this.setLayout(new BoxLayout(1));
                this.spin = new Spinner[this.model.length];
                int slen = this.spin.length;
                for (int iter = 0; iter < slen; ++iter) {
                    this.spin[iter] = this.createSpinner(iter);
                    this.addComponent(this.spin[iter]);
                    if (iter < slen - 1) {
                        this.addComponent(this.createSeparator());
                    }
                    if (this.renderingPrototype == null) continue;
                    this.spin[iter].setRenderingPrototype(this.renderingPrototype[iter]);
                }
            }
        }
    }

    public void setColumns(int columns) {
        if (this.model.length != columns) {
            ListModel[] lm = new ListModel[columns];
            ListCellRenderer[] lr = new ListCellRenderer[columns];
            Object[] values = new Object[columns];
            String[] rp = new String[columns];
            if (this.spin != null) {
                this.spin = null;
                this.removeAll();
                this.initSpinner();
            }
            for (int iter = 0; iter < columns; ++iter) {
                lm[iter] = this.model[Math.min(iter, this.model.length - 1)];
                lr[iter] = this.renderer[Math.min(iter, this.model.length - 1)];
                if (this.value != null) {
                    values[iter] = this.value[Math.min(iter, this.model.length - 1)];
                }
                if (this.renderingPrototype == null) continue;
                rp[iter] = this.renderingPrototype[Math.min(iter, this.model.length - 1)];
            }
            this.model = lm;
            this.renderer = lr;
            this.value = values;
            this.renderingPrototype = rp;
        }
    }

    public String getRenderingPrototype() {
        return this.getRenderingPrototype(0);
    }

    public String getRenderingPrototype(int column) {
        if (this.renderingPrototype == null) {
            return null;
        }
        return this.renderingPrototype[column];
    }

    public void setRenderingPrototype(String pr) {
        this.setRenderingPrototype(0, pr);
    }

    public void setRenderingPrototype(int column, String pr) {
        if (this.renderingPrototype == null) {
            this.renderingPrototype = new String[this.model.length];
        }
        this.renderingPrototype[column] = pr;
    }

    public int getColumns() {
        return this.model.length;
    }

    public Object getValue() {
        return this.getValue(0);
    }

    public Object getValue(int offset) {
        if (this.spin != null && this.spin[offset] != null) {
            return this.spin[offset].getModel().getItemAt(this.spin[offset].getModel().getSelectedIndex());
        }
        if (this.model[offset] != null) {
            return this.model[offset].getItemAt(this.model[offset].getSelectedIndex());
        }
        return this.value;
    }

    public void setValue(Object value) {
        this.setValue(0, value);
    }

    public void setValue(int offset, Object value) {
        if (this.value == null) {
            this.value = new Object[this.model.length];
        }
        this.value[offset] = value;
        if (this.spin != null && this.spin[offset] != null) {
            this.spin[offset].setValue(value);
        }
    }

    Spinner createSpinner(int column) {
        Spinner spin = new Spinner(this.model[column], this.renderer[column]);
        spin.setRenderingPrototype(null);
        spin.setShouldCalcPreferredSize(true);
        spin.setListSizeCalculationSampleCount(30);
        spin.initSpinnerRenderer();
        spin.updateToDefaultRTL();
        if (this.value != null && this.value[column] != null) {
            spin.setValue(this.value[column]);
        }
        return spin;
    }

    public String[] getPropertyNames() {
        return new String[]{"model", "renderer", "items", "columns"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{ListModel.class, ListCellRenderer.class, CodenameOneImplementation.getStringArrayClass(), Integer.class};
    }

    public String[] getPropertyTypeNames() {
        return new String[]{"ListModel", "ListCellRenderer", "String[]", "int"};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("items")) {
            ListModel m = this.getModel();
            String[] s = new String[m.getSize()];
            int slen = s.length;
            for (int iter = 0; iter < slen; ++iter) {
                Object o = m.getItemAt(iter);
                if (o == null) continue;
                s[iter] = o.toString();
            }
            return s;
        }
        if (name.equals("model")) {
            return this.getModel();
        }
        if (name.equals("renderer")) {
            return this.getRenderer();
        }
        if (name.equals("columns")) {
            return new Integer(this.getColumns());
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("items")) {
            this.setModel(new DefaultListModel<Object>((Object[])value));
            return null;
        }
        if (name.equals("model")) {
            this.setModel((ListModel)value);
            return null;
        }
        if (name.equals("renderer")) {
            this.setRenderer((ListCellRenderer)value);
            return null;
        }
        if (name.equals("columns")) {
            this.setColumns((Integer)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public ListModel getModel() {
        return this.model[0];
    }

    public ListModel getModel(int offset) {
        return this.model[offset];
    }

    public void setModel(ListModel model) {
        this.setModel(0, model);
    }

    public void setModel(int offset, ListModel model) {
        this.model[offset] = model;
        if (this.spin != null && this.spin[offset] != null) {
            this.spin[offset].setModel(model);
        }
    }

    public ListCellRenderer getRenderer(int offset) {
        return this.renderer[offset];
    }

    public void setRenderer(int offset, ListCellRenderer renderer) {
        this.renderer[offset] = renderer;
        if (this.spin != null && this.spin[offset] != null) {
            this.spin[offset].setRenderer(renderer);
        }
    }

    public ListCellRenderer getRenderer() {
        return this.getRenderer(0);
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.setRenderer(0, renderer);
    }

    public Object getComponentState() {
        if (this.getColumns() == 1) {
            return this.getValue();
        }
        Object[] o = new Object[this.getColumns()];
        int olen = o.length;
        for (int iter = 0; iter < olen; ++iter) {
            o[iter] = this.getValue(iter);
        }
        return o;
    }

    public void setComponentState(Object state) {
        if (this.getColumns() == 1) {
            this.setValue(state);
            return;
        }
        Object[] o = (Object[])state;
        int olen = o.length;
        for (int iter = 0; iter < olen; ++iter) {
            this.setValue(iter, o[iter]);
        }
    }
}

