/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.handle;

import com.composum.sling.clientlibs.handle.ClientlibElement;
import com.composum.sling.clientlibs.handle.ClientlibLink;
import com.composum.sling.clientlibs.handle.ClientlibRef;
import com.composum.sling.clientlibs.handle.ClientlibResourceFolder;
import com.composum.sling.clientlibs.handle.ClientlibVisitor;
import com.composum.sling.core.ResourceHandle;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clientlib
implements ClientlibElement {
    private static final Logger LOG = LoggerFactory.getLogger(Clientlib.class);
    public static final String CATEGORYNAME_CHARS = "a-zA-Z0-9._-";
    public static final String PROP_CATEGORY = "category";
    public static final String PROP_ORDER = "order";
    public static final String RESOURCE_TYPE = "composum/nodes/commons/clientlib";
    private final Type type;
    public final ResourceHandle resource;

    @Override
    public ClientlibRef getRef() {
        return new ClientlibRef(this.getType(), this.resource.getPath(), true, null);
    }

    @Override
    public ClientlibLink makeLink() {
        return new ClientlibLink(this.getType(), ClientlibLink.Kind.CLIENTLIB, this.resource.getPath(), null);
    }

    public Clientlib(Type type, Resource resource) {
        this.type = type;
        this.resource = ResourceHandle.use(resource);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public boolean isValid() {
        return this.resource.isResourceType(RESOURCE_TYPE);
    }

    public ClientlibResourceFolder getResourceFolder() {
        Resource child = this.resource.getChild(this.getType().name());
        return null != child ? new ClientlibResourceFolder(this.getType(), child) : null;
    }

    public int getOrder() {
        return this.resource.getProperty(PROP_ORDER, 0);
    }

    @Nonnull
    public List<String> getCategories() {
        return Arrays.asList((Object[])this.resource.getProperty(PROP_CATEGORY, new String[0]));
    }

    @Override
    public void accept(ClientlibVisitor visitor, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) throws IOException, RepositoryException {
        visitor.visit(this, mode, parent);
    }

    public String toString() {
        return (Object)((Object)this.getType()) + ":" + this.resource.getPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Clientlib)) {
            return false;
        }
        Clientlib that = (Clientlib)o;
        if (this.getType() != that.getType()) {
            return false;
        }
        return this.resource != null ? this.resource.getPath().equals(that.resource.getPath()) : that.resource == null;
    }

    public int hashCode() {
        int result = this.getType() != null ? this.getType().hashCode() : 0;
        result = 92821 * result + (this.resource != null ? this.resource.getPath().hashCode() : 0);
        return result;
    }

    public static String sanitizeCategory(String category) {
        String res = null;
        if (StringUtils.isNotBlank((CharSequence)category) && !(res = category.trim().replaceAll("[^a-zA-Z0-9._-]", "")).equals(category)) {
            LOG.error("Invalid characters in category {}", (Object)category);
        }
        return res;
    }

    public static enum Type {
        link,
        css,
        js,
        img;

    }
}

