/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.processor;

import com.composum.sling.clientlibs.handle.ClientlibElement;
import com.composum.sling.clientlibs.handle.ClientlibFile;
import com.composum.sling.clientlibs.handle.ClientlibLink;
import com.composum.sling.clientlibs.handle.ClientlibRef;
import com.composum.sling.clientlibs.handle.ClientlibResourceFolder;
import com.composum.sling.clientlibs.handle.ClientlibVisitor;
import com.composum.sling.clientlibs.handle.FileHandle;
import com.composum.sling.clientlibs.processor.AbstractClientlibVisitor;
import com.composum.sling.clientlibs.processor.ProcessorContext;
import com.composum.sling.clientlibs.service.ClientlibProcessor;
import com.composum.sling.clientlibs.service.ClientlibService;
import com.composum.sling.core.ResourceHandle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessingVisitor
extends AbstractClientlibVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessingVisitor.class);
    protected final OutputStream output;
    protected final ClientlibProcessor processor;
    protected final ProcessorContext context;

    public ProcessingVisitor(ClientlibElement owner, ClientlibService service, OutputStream output, ClientlibProcessor processor, ProcessorContext context) {
        super(owner, service, context.getResolver(), null);
        this.output = output;
        this.processor = processor;
        this.context = context;
    }

    @Override
    protected ClientlibVisitor createVisitorFor(ClientlibElement element) {
        return new ExcludeDependenciesVisitor(element, this.service, this.resolver, this.processedElements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void action(ClientlibFile clientlibFile, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) throws IOException {
        FileHandle file;
        InputStream content;
        if (ClientlibVisitor.VisitorMode.EMBEDDED != mode) {
            return;
        }
        LOG.trace("Processing {} with {}", (Object)clientlibFile, (Object)this.processor);
        long begin = System.currentTimeMillis();
        ResourceHandle resource = clientlibFile.handle.getResource();
        if (this.context.useMinifiedFiles()) {
            resource = this.service.getMinifiedSibling(resource);
        }
        if ((content = (file = new FileHandle(resource)).getStream()) != null) {
            try {
                if (this.processor != null) {
                    content = this.processor.processContent(content, this.context);
                }
                IOUtils.copy((InputStream)content, (OutputStream)this.output);
                this.output.write(10);
                this.output.write(10);
                this.output.flush();
            }
            finally {
                content.close();
            }
        } else {
            this.logNotAvailable(resource, "[content]", parent.getOptional());
        }
        float time = 0.001f * (float)(System.currentTimeMillis() - begin);
        LOG.trace("Processed {} in {} s", (Object)clientlibFile, (Object)Float.valueOf(time));
        if ((double)time > 0.1) {
            LOG.info("Large processing time: {} in {} s", (Object)clientlibFile, (Object)Float.valueOf(time));
        }
    }

    protected void logNotAvailable(Resource resource, String reference, boolean optional) {
        if (optional) {
            LOG.debug("Clientlib entry ''{}'' of ''{}'' not available but optional.", (Object)reference, (Object)resource.getPath());
        } else {
            LOG.warn("Clientlib entry ''{}'' of ''{}'' not available.", (Object)reference, (Object)resource.getPath());
        }
    }

    @Override
    protected void alreadyProcessed(ClientlibRef ref, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder folder) {
        if (mode == ClientlibVisitor.VisitorMode.EMBEDDED) {
            LOG.warn("Trying to embed already embedded / dependency {} again at {}", (Object)ref, (Object)folder);
        }
    }

    protected static class ExcludeDependenciesVisitor
    extends AbstractClientlibVisitor {
        protected ExcludeDependenciesVisitor(ClientlibElement owner, ClientlibService service, ResourceResolver resolver, LinkedHashSet<ClientlibLink> processedElements) {
            super(owner, service, resolver, processedElements);
        }

        @Override
        protected ClientlibVisitor createVisitorFor(ClientlibElement element) {
            return new ExcludeDependenciesVisitor(element, this.service, this.resolver, this.processedElements);
        }
    }
}

