/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.service;

import com.composum.sling.clientlibs.handle.Clientlib;
import com.composum.sling.clientlibs.handle.ClientlibCategory;
import com.composum.sling.clientlibs.handle.ClientlibElement;
import com.composum.sling.clientlibs.handle.ClientlibExternalUri;
import com.composum.sling.clientlibs.handle.ClientlibFile;
import com.composum.sling.clientlibs.handle.ClientlibLink;
import com.composum.sling.clientlibs.handle.ClientlibRef;
import com.composum.sling.clientlibs.handle.ClientlibResourceFolder;
import com.composum.sling.clientlibs.handle.FileHandle;
import com.composum.sling.clientlibs.processor.CssProcessor;
import com.composum.sling.clientlibs.processor.CssUrlMapper;
import com.composum.sling.clientlibs.processor.GzipProcessor;
import com.composum.sling.clientlibs.processor.JavascriptProcessor;
import com.composum.sling.clientlibs.processor.LinkRenderer;
import com.composum.sling.clientlibs.processor.ProcessingVisitor;
import com.composum.sling.clientlibs.processor.ProcessorContext;
import com.composum.sling.clientlibs.processor.ProcessorPipeline;
import com.composum.sling.clientlibs.processor.RendererContext;
import com.composum.sling.clientlibs.processor.UpdateTimeVisitor;
import com.composum.sling.clientlibs.service.ClientlibConfiguration;
import com.composum.sling.clientlibs.service.ClientlibPermissionPlugin;
import com.composum.sling.clientlibs.service.ClientlibProcessor;
import com.composum.sling.clientlibs.service.ClientlibRenderer;
import com.composum.sling.clientlibs.service.ClientlibService;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.concurrent.LazyCreationService;
import com.composum.sling.core.concurrent.SequencerService;
import com.composum.sling.core.filter.ResourceFilter;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Composum Nodes Clientlib Service: Delivers the composed clientlib content bundled and compressed."})
public class DefaultClientlibService
implements ClientlibService {
    public static final String MINIFIED_SELECTOR = ".min";
    public static final Pattern UNMINIFIED_PATTERN = Pattern.compile("^(.+/)([^/]+)(\\.min)?(\\.[^.]+)$");
    public static final Pattern MINIFIED_PATTERN = Pattern.compile("^(.+/)([^/]+)(\\.min)(\\.[^.]+)?$");
    public static final String PROP_HASH = "jcr:description";
    public static final Map<String, Object> CRUD_CACHE_FOLDER_PROPS = new HashMap<String, Object>();
    protected static final String CATEGORYCACHE = "categorycache";
    private static final Logger LOG;
    @Reference
    protected ClientlibConfiguration clientlibConfig;
    @Reference
    protected ResourceResolverFactory resolverFactory;
    @Reference
    protected SequencerService sequencer;
    @Reference
    protected LazyCreationService lazyCreationService;
    @Reference
    protected JavascriptProcessor javascriptProcessor;
    @Reference
    protected CssProcessor cssProcessor;
    @Reference
    protected LinkRenderer linkRenderer;
    @Reference
    protected GzipProcessor gzipProcessor;
    @Reference(service=ClientlibPermissionPlugin.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, bind="bindPermissionPlugin", unbind="unbindPermissionPlugin")
    protected final List<ClientlibPermissionPlugin> permissionPlugins = new CopyOnWriteArrayList<ClientlibPermissionPlugin>();
    protected ThreadPoolExecutor executorService = null;
    protected EnumMap<Clientlib.Type, ClientlibRenderer> rendererMap;
    protected EnumMap<Clientlib.Type, ClientlibProcessor> processorMap;
    protected final LRUMap categoryToPathCache = new LRUMap(100);
    protected static final Comparator<Resource> orderResourceComparator;
    protected static final String QUERY_CLIENTLIBS = "/jcr:root/(apps|libs)//*[sling:resourceType='composum/nodes/commons/clientlib']";
    protected static final String QUERY_SUFFIX_REFERENCERS = "[embed or depends]";

    protected synchronized void bindPermissionPlugin(ClientlibPermissionPlugin permissionPlugin) {
        this.permissionPlugins.add(permissionPlugin);
        this.categoryToPathCache.clear();
    }

    protected synchronized void unbindPermissionPlugin(ClientlibPermissionPlugin permissionPlugin) {
        this.permissionPlugins.remove(permissionPlugin);
        this.categoryToPathCache.clear();
    }

    @Modified
    @Activate
    protected void activate(ComponentContext context) {
        ClientlibConfiguration.Config config = this.getClientlibConfig();
        this.executorService = new ThreadPoolExecutor(config.clientlibs_threadpool_min(), config.clientlibs_threadpool_max(), 200L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.rendererMap = new EnumMap(Clientlib.Type.class);
        this.rendererMap.put(Clientlib.Type.js, this.javascriptProcessor);
        this.rendererMap.put(Clientlib.Type.css, this.cssProcessor);
        this.rendererMap.put(Clientlib.Type.link, this.linkRenderer);
        this.processorMap = new EnumMap(Clientlib.Type.class);
        this.processorMap.put(Clientlib.Type.js, this.javascriptProcessor);
        this.processorMap.put(Clientlib.Type.css, this.getClientlibConfig().clientlibs_url_map() ? new ProcessorPipeline(new CssUrlMapper(), this.cssProcessor) : this.cssProcessor);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
    }

    @Override
    public ClientlibElement resolve(ClientlibRef ref, ResourceResolver resolver) {
        if (ref != null) {
            if (ref.isCategory()) {
                List<Resource> resources = this.retrieveCategoryResources(ref.category, resolver);
                if (!resources.isEmpty()) {
                    return new ClientlibCategory(ref, resources);
                }
            } else {
                if (ref.isExternalUri()) {
                    return new ClientlibExternalUri(ref.type, ref.externalUri, ref.properties);
                }
                Resource resource = this.retrieveResource(ref.path, resolver);
                if (null != resource) {
                    if (resource.isResourceType("composum/nodes/commons/clientlib")) {
                        return new Clientlib(ref.type, resource);
                    }
                    if (ClientlibFile.isFile(resource)) {
                        resource = this.minificationVariant(resource);
                        return new ClientlibFile(ref, ref.type, resource, ref.properties);
                    }
                    LOG.warn("Ignored resource {} with unknown type {}", (Object)resource.getPath(), (Object)resource.getResourceType());
                }
            }
            if (ref.optional) {
                LOG.debug("Could not resolve {}", (Object)ref);
            } else {
                LOG.warn("Could not resolve {}", (Object)ref);
            }
        } else {
            try {
                throw new RuntimeException("Clientlib ref is NULL!");
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    protected Resource minificationVariant(Resource resource) {
        if (this.getClientlibConfig().clientlibs_minified_use() && !this.getClientlibConfig().debug()) {
            return this.getMinifiedSibling(resource);
        }
        return resource;
    }

    protected Resource retrieveResource(String path, ResourceResolver resolver) {
        Resource pathResource = this.retrieveResourceRaw(path, resolver);
        if (null == pathResource) {
            String minifiedPath;
            String unminifiedPath = this.getUnminifiedSibling(path);
            if (!path.equals(unminifiedPath)) {
                pathResource = this.retrieveResourceRaw(unminifiedPath, resolver);
            }
            if (null == pathResource && !(minifiedPath = this.getMinifiedSibling(path)).equals(path)) {
                pathResource = this.retrieveResourceRaw(minifiedPath, resolver);
            }
        }
        if (pathResource != null) {
            LOG.debug("retrieveResource {} uses {}", (Object)path, (Object)pathResource);
        } else {
            LOG.debug("retrieveResource.failed: {}", (Object)path);
        }
        return pathResource;
    }

    protected Resource retrieveResourceRaw(String path, ResourceResolver resolver) {
        Resource pathResource = null;
        if (path.startsWith("/")) {
            pathResource = resolver.getResource(path);
        } else {
            String[] searchPath = resolver.getSearchPath();
            for (int i = 0; pathResource == null && i < searchPath.length; ++i) {
                String absolutePath = searchPath[i] + path;
                pathResource = resolver.getResource(absolutePath);
            }
        }
        return pathResource;
    }

    protected String getMinifiedSibling(String path) {
        Matcher matcher = UNMINIFIED_PATTERN.matcher(path);
        if (matcher.matches() && StringUtils.isBlank((CharSequence)matcher.group(3))) {
            String ext = matcher.group(4);
            String minified = matcher.group(1) + matcher.group(2) + MINIFIED_SELECTOR;
            if (StringUtils.isNotBlank((CharSequence)ext)) {
                minified = minified + ext;
            }
            return minified;
        }
        return path;
    }

    protected String getUnminifiedSibling(String path) {
        Matcher matcher = MINIFIED_PATTERN.matcher(path);
        if (matcher.matches() && StringUtils.isNotBlank((CharSequence)matcher.group(3))) {
            String ext = matcher.group(4);
            String unminified = matcher.group(1) + matcher.group(2);
            if (StringUtils.isNotBlank((CharSequence)ext)) {
                unminified = unminified + ext;
            }
            return unminified;
        }
        return path;
    }

    @Override
    @Nonnull
    public Resource getMinifiedSibling(@Nonnull Resource resource) {
        Resource minified;
        String minifiedPath;
        String path = resource.getPath();
        if (!path.equals(minifiedPath = this.getMinifiedSibling(path)) && (minified = resource.getResourceResolver().getResource(minifiedPath)) != null) {
            return minified;
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Resource> retrieveCategoryResources(String category, ResourceResolver resolver) {
        long cacheTime = TimeUnit.SECONDS.toMillis(this.getClientlibConfig().clientlibs_resolver_cache_time());
        if (cacheTime <= 0L) {
            return this.retrieveResourcesForCategoryUncached(category, resolver);
        }
        List<String> paths = null;
        long currentTimeMillis = System.currentTimeMillis();
        LRUMap lRUMap = this.categoryToPathCache;
        synchronized (lRUMap) {
            Pair cacheEntry = (Pair)this.categoryToPathCache.get((Object)category);
            if (null != cacheEntry && (Long)cacheEntry.getLeft() >= currentTimeMillis - cacheTime) {
                paths = (List)cacheEntry.getRight();
            }
        }
        if (null == paths) {
            paths = new ArrayList();
            ResourceResolver administrativeResolver = this.createAdministrativeResolver();
            Object object = null;
            try {
                List<Resource> resourcesForAdmin = this.retrieveResourcesForCategoryUncached(category, administrativeResolver);
                for (Resource resource : resourcesForAdmin) {
                    paths.add(resource.getPath());
                }
            }
            catch (Throwable resourcesForAdmin) {
                object = resourcesForAdmin;
                throw resourcesForAdmin;
            }
            finally {
                if (administrativeResolver != null) {
                    if (object != null) {
                        try {
                            administrativeResolver.close();
                        }
                        catch (Throwable resourcesForAdmin) {
                            ((Throwable)object).addSuppressed(resourcesForAdmin);
                        }
                    } else {
                        administrativeResolver.close();
                    }
                }
            }
            administrativeResolver = this.categoryToPathCache;
            synchronized (administrativeResolver) {
                this.categoryToPathCache.put((Object)category, (Object)Pair.of((Object)currentTimeMillis, paths));
            }
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String path : paths) {
            Resource resource = resolver.getResource(path);
            if (null == resource) continue;
            resources.add(resource);
        }
        return resources;
    }

    protected List<Resource> retrieveResourcesForCategoryUncached(String category, ResourceResolver resolver) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        HashSet<String> foundlibs = new HashSet<String>();
        List<ResourceFilter> permissionFilters = this.getCategoryPermissionFilters(category);
        for (String searchPathElement : resolver.getSearchPath()) {
            String xpath = "/jcr:root" + searchPathElement.replaceFirst("/+$", "") + "//element(*," + "sling:Folder" + ")[@" + "sling:resourceType" + "='" + "composum/nodes/commons/clientlib" + "' and @" + "category" + "='" + category + "']";
            Iterator iterator = resolver.findResources(xpath, "xpath");
            while (iterator.hasNext()) {
                Resource foundResource = (Resource)iterator.next();
                ResourceHandle handle = ResourceHandle.use(foundResource);
                String libPath = handle.getPath();
                String key = libPath.substring(libPath.indexOf(searchPathElement) + searchPathElement.length());
                if (foundlibs.contains(key) || !this.isClientlibPermitted(permissionFilters, handle)) continue;
                foundlibs.add(key);
                resources.add(handle);
            }
        }
        resources.sort(orderResourceComparator);
        return resources;
    }

    @Nonnull
    protected List<ResourceFilter> getCategoryPermissionFilters(String category) {
        ArrayList<ResourceFilter> result = new ArrayList<ResourceFilter>();
        for (ClientlibPermissionPlugin plugin : this.permissionPlugins) {
            result.add(plugin.categoryFilter(category));
        }
        return result;
    }

    protected boolean isClientlibPermitted(@Nonnull List<ResourceFilter> filters, Resource clientlibResource) {
        boolean permitted = true;
        for (ResourceFilter filter : filters) {
            permitted = permitted && filter.accept(clientlibResource);
        }
        return permitted;
    }

    protected ResourceResolver createAdministrativeResolver() {
        try {
            return this.resolverFactory.getAdministrativeResourceResolver(null);
        }
        catch (LoginException e) {
            throw new SlingException("Configuration problem: we cannot get an administrative resolver ", (Throwable)e);
        }
    }

    @Override
    public ClientlibConfiguration.Config getClientlibConfig() {
        return this.clientlibConfig.getConfig();
    }

    @Override
    public void renderClientlibLinks(ClientlibElement clientlib, Writer writer, SlingHttpServletRequest request, RendererContext context) throws IOException, RepositoryException {
        Clientlib.Type type = clientlib.getType();
        ClientlibRenderer renderer = this.rendererMap.get((Object)type);
        if (renderer != null) {
            renderer.renderClientlibLinks(clientlib, writer, request, context);
        }
    }

    @Override
    public ClientlibService.ClientlibInfo prepareContent(SlingHttpServletRequest request, ClientlibRef clientlibRef, boolean minified, String rawEncoding, boolean forceRefreshCache, String requestedHash, long ifModifiedSince) throws IOException, RepositoryException {
        boolean refreshForced;
        ClientlibElement element = this.resolve(clientlibRef, request.getResourceResolver());
        if (null == element) {
            LOG.error("No client libraries found for {}", (Object)clientlibRef);
            throw new FileNotFoundException("No client libraries for " + clientlibRef);
        }
        String encoding = this.adjustEncoding(rawEncoding);
        String cachePath = this.getCachePath(clientlibRef, minified, encoding);
        FileHandle cacheFile = new FileHandle(this.lazyCreationService.waitForInitialization(request.getResourceResolver(), cachePath));
        ClientlibService.ClientlibInfo fileHints = this.getFileHints(cacheFile, element.makeLink());
        boolean ifModifiedIsOlder = ifModifiedSince > 0L && null != cacheFile.getLastModified() && ifModifiedSince < cacheFile.getLastModified().getTimeInMillis();
        boolean cacheAssumedRecent = null != fileHints && null != fileHints.hash && (fileHints.hash.equals(requestedHash) || ifModifiedIsOlder);
        boolean bl = refreshForced = forceRefreshCache || null == fileHints || null == cacheFile.getLastModified();
        if (refreshForced || !cacheAssumedRecent) {
            try (ResourceResolver adminResolver = this.createAdministrativeResolver();){
                boolean refreshNeeded;
                cacheFile = new FileHandle(adminResolver.getResource(cachePath));
                if (cacheFile.isValid() && null == request.getResourceResolver().getResource(cachePath)) {
                    this.refreshSession(request.getResourceResolver(), true);
                    if (null == request.getResourceResolver().getResource(cachePath)) {
                        LOG.warn("Cache file exists but is not accessible for user: {}", (Object)cachePath);
                        ClientlibService.ClientlibInfo clientlibInfo = null;
                        return clientlibInfo;
                    }
                }
                element = this.resolve(clientlibRef, adminResolver);
                UpdateTimeVisitor updateTimeVisitor = new UpdateTimeVisitor(element, this, adminResolver);
                updateTimeVisitor.execute();
                String hash = updateTimeVisitor.getHash();
                String cacheFileHash = cacheFile.getContent().getProperty(PROP_HASH);
                if (!StringUtils.equals((CharSequence)requestedHash, (CharSequence)hash)) {
                    UpdateTimeVisitor updateTimeVisitorAsUser = new UpdateTimeVisitor(element, this, request.getResourceResolver());
                    updateTimeVisitorAsUser.execute();
                    if (!StringUtils.equals((CharSequence)hash, (CharSequence)updateTimeVisitorAsUser.getHash())) {
                        LOG.error("Clientlib hash for {} as {} and admin disagree - likely a permission problem that results in performance problems", (Object)request.getUserPrincipal(), (Object)clientlibRef);
                    }
                }
                boolean bl2 = refreshNeeded = refreshForced || !hash.equals(cacheFileHash);
                if (null != cacheFile.getLastModified() && null != updateTimeVisitor.getLastUpdateTime() && updateTimeVisitor.getLastUpdateTime().after(cacheFile.getLastModified())) {
                    refreshNeeded = true;
                }
                if (refreshNeeded) {
                    LOG.info("prepare ''{}''...", (Object)clientlibRef);
                    Resource cacheEntry = adminResolver.getResource(cachePath);
                    if (cacheEntry != null) {
                        LOG.info("deleting to be refreshed ''{}''...", (Object)cacheEntry);
                        adminResolver.delete(cacheEntry);
                        adminResolver.commit();
                    }
                    ProcessorContext context = new ProcessorContext(request, adminResolver, this.executorService, this.getClientlibConfig().clientlibs_url_map(), minified && this.getClientlibConfig().clientlibs_minified_use() && !this.getClientlibConfig().debug());
                    LazyCreationService.InitializationStrategy initializer = this.initializationStrategy(clientlibRef, encoding, hash, context);
                    Resource resource = this.lazyCreationService.getOrCreate(request.getResourceResolver(), cachePath, LazyCreationService.IDENTITY_RETRIEVER, this.creationStrategy(), initializer, CRUD_CACHE_FOLDER_PROPS);
                    cacheFile = new FileHandle(resource);
                }
                fileHints = this.getFileHints(cacheFile, element.makeLink());
            }
        }
        LOG.debug("Hints: {}", (Object)fileHints);
        return fileHints;
    }

    protected LazyCreationService.CreationStrategy creationStrategy() {
        return (adminResolver, parent, name) -> {
            Resource cacheEntry = adminResolver.create(parent, name, FileHandle.CRUD_FILE_PROPS);
            ((Node)Objects.requireNonNull(adminResolver.create(cacheEntry, "jcr:content", FileHandle.CRUD_CONTENT_PROPS).adaptTo(Node.class))).addMixin("mix:title");
            FileHandle cacheFile = new FileHandle(cacheEntry);
            cacheFile.storeContent(new ByteArrayInputStream("".getBytes()));
            return cacheEntry;
        };
    }

    protected LazyCreationService.InitializationStrategy initializationStrategy(ClientlibRef clientlibRef, String encoding, String hash, ProcessorContext context) {
        return (adminResolver, cacheEntry) -> {
            try {
                FileHandle cacheFile = new FileHandle(cacheEntry);
                if (cacheFile.isValid()) {
                    LOG.debug("create clientlib cache content ''{}''...", (Object)cacheFile.getResource().getPath());
                    PipedOutputStream outputStream = new PipedOutputStream();
                    InputStream inputStream = new PipedInputStream(outputStream);
                    Future<Void> result = this.startProcessing(clientlibRef, encoding, context, outputStream);
                    if ("gzip".equals(encoding)) {
                        inputStream = this.gzipProcessor.processContent(inputStream, context);
                    }
                    cacheFile.storeContent(inputStream);
                    ModifiableValueMap contentValues = Objects.requireNonNull(cacheFile.getContent().adaptTo(ModifiableValueMap.class));
                    contentValues.put((Object)"jcr:lastModified", (Object)Calendar.getInstance());
                    contentValues.putAll(context.getHints());
                    contentValues.put((Object)PROP_HASH, (Object)hash);
                    adminResolver.commit();
                    result.get();
                    LOG.info("clientlib cache content ''{}'' created", (Object)cacheFile.getResource().getPath());
                } else {
                    LOG.error("can't create cache content in '{}'!", (Object)cacheFile.getResource().getPath());
                }
            }
            catch (Exception e) {
                LOG.error("Error when initializing content in " + cacheEntry + "; deleting the file", (Throwable)e);
                this.refreshSession(adminResolver, false);
                adminResolver.delete(cacheEntry);
                throw new PersistenceException("" + e, (Throwable)e);
            }
        };
    }

    protected Future<Void> startProcessing(ClientlibRef clientlibRef, String encoding, ProcessorContext context, OutputStream outputStream) {
        ClientlibProcessor processor = this.processorMap.get((Object)clientlibRef.type);
        return context.submit(() -> {
            try (ResourceResolver processingAdminResolver = this.createAdministrativeResolver();){
                ClientlibElement adminElement = this.resolve(clientlibRef, processingAdminResolver);
                ProcessingVisitor visitor = new ProcessingVisitor(adminElement, this, outputStream, processor, context);
                visitor.execute();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
            return null;
        });
    }

    protected ClientlibService.ClientlibInfo getFileHints(FileHandle file, ClientlibLink link) {
        if (file.isValid()) {
            ClientlibService.ClientlibInfo hints = new ClientlibService.ClientlibInfo();
            ValueMap contentValues = file.getContent().getValueMap();
            hints.lastModified = (Calendar)contentValues.get("jcr:lastModified", Calendar.class);
            hints.mimeType = (String)contentValues.get("jcr:mimeType", String.class);
            hints.encoding = (String)contentValues.get("jcr:encoding", String.class);
            hints.hash = (String)contentValues.get(PROP_HASH, String.class);
            hints.size = file.getSize();
            hints.link = link.withHash(hints.hash);
            return hints;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliverContent(ResourceResolver resolver, ClientlibRef clientlibRef, boolean minified, OutputStream outputStream, String encoding) throws IOException, RepositoryException {
        String cachePath = this.getCachePath(clientlibRef, minified, encoding = this.adjustEncoding(encoding));
        Resource resource = this.lazyCreationService.waitForInitialization(resolver, cachePath);
        FileHandle file = new FileHandle(resource);
        if (file.isValid()) {
            InputStream content = file.getStream();
            if (content != null) {
                try {
                    IOUtils.copy((InputStream)content, (OutputStream)outputStream);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)content);
                }
            }
        } else {
            throw new FileNotFoundException("No cached file found for " + clientlibRef);
        }
    }

    protected String getCachePath(ClientlibRef ref, boolean minified, String encoding) {
        String cacheKey;
        String cacheRoot = this.getClientlibConfig().clientlibs_cache_root();
        String string = cacheKey = ref.isCategory() ? "/categorycache/" + ref.category : ref.path;
        if (StringUtils.isNotBlank((CharSequence)encoding)) {
            cacheKey = cacheKey + '.' + encoding.trim();
        }
        if (minified && this.getClientlibConfig().clientlibs_minified_use() && !this.getClientlibConfig().debug()) {
            cacheKey = cacheKey + MINIFIED_SELECTOR;
        }
        cacheKey = cacheKey + "." + ref.type.name();
        return cacheRoot + cacheKey;
    }

    protected String adjustEncoding(String encoding) {
        if ("gzip".equals(encoding) && !this.getClientlibConfig().gzip_enabled()) {
            encoding = null;
        }
        return encoding;
    }

    protected void refreshSession(ResourceResolver resolver, boolean logwarning) {
        block2: {
            try {
                ((Session)Objects.requireNonNull(resolver.adaptTo(Session.class))).refresh(true);
            }
            catch (RepositoryException rex) {
                if (!logwarning) break block2;
                LOG.warn(rex.getMessage(), (Throwable)rex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String verifyClientlibPermissions(@Nullable Clientlib.Type requestedType, @Nullable ResourceResolver userResolver, boolean onlyErrors) {
        String querySuffix = requestedType != null ? "/" + requestedType.name() + "//*" : "//*";
        String onlyClientlibQuerySuffix = requestedType != null ? "/" + requestedType.name() + "/.." : "";
        StringBuilder buf = new StringBuilder();
        ResourceResolver impersonationResolver = userResolver;
        ResourceResolver administrativeResolver = null;
        try {
            Resource clientlibElement;
            if (impersonationResolver == null) {
                impersonationResolver = this.resolverFactory.getResourceResolver(null);
            }
            administrativeResolver = this.createAdministrativeResolver();
            List<String> unreachablePaths = new ArrayList<String>();
            Iterator it = administrativeResolver.findResources(QUERY_CLIENTLIBS + onlyClientlibQuerySuffix + " order by path", "xpath");
            HashSet<Object> categoriesWithReachableClientlibs = new HashSet<Object>();
            HashSet<Object> categoriesWithUnreachableClientlibs = new HashSet<Object>();
            HashSet<String> allCategories = new HashSet<String>();
            while (it.hasNext()) {
                Resource clientlibElement2 = (Resource)it.next();
                List<Object> categories = Arrays.asList((Object[])ResourceHandle.use(clientlibElement2).getProperty("category", new String[0]));
                allCategories.addAll(categories);
                if (impersonationResolver.getResource(clientlibElement2.getPath()) == null) {
                    unreachablePaths.add(clientlibElement2.getPath());
                    categoriesWithUnreachableClientlibs.addAll(categories);
                    continue;
                }
                categoriesWithReachableClientlibs.addAll(categories);
            }
            Collection troubledCategories = CollectionUtils.intersection(categoriesWithReachableClientlibs, categoriesWithUnreachableClientlibs);
            if (!troubledCategories.isEmpty()) {
                buf.append("ERROR: Categories with both readable AND unreadable elements: ").append(troubledCategories).append("\n");
            }
            it = administrativeResolver.findResources(QUERY_CLIENTLIBS + querySuffix + " order by path", "xpath");
            while (it.hasNext()) {
                clientlibElement = (Resource)it.next();
                if (impersonationResolver.getResource(clientlibElement.getPath()) != null) continue;
                if (!this.isReachableFrom(unreachablePaths, clientlibElement.getPath())) {
                    buf.append("ERROR: unreadable element of readable client library: ").append(clientlibElement.getPath()).append("\n");
                }
                unreachablePaths.add(clientlibElement.getPath());
            }
            unreachablePaths = this.removeChildren(unreachablePaths);
            if (!onlyErrors && !unreachablePaths.isEmpty()) {
                buf.insert(0, "INFO: Unreadable for this user: " + unreachablePaths + "\n");
            }
            it = administrativeResolver.findResources(QUERY_CLIENTLIBS + querySuffix + QUERY_SUFFIX_REFERENCERS + " order by path", "xpath");
            while (it.hasNext()) {
                clientlibElement = (Resource)it.next();
                if (this.isReachableFrom(unreachablePaths, clientlibElement.getPath())) continue;
                Resource clientlibFolderResource = clientlibElement;
                while (!Objects.requireNonNull(clientlibFolderResource.getParent()).isResourceType("composum/nodes/commons/clientlib")) {
                    clientlibFolderResource = clientlibFolderResource.getParent();
                }
                Clientlib.Type type = null;
                try {
                    type = Clientlib.Type.valueOf(clientlibFolderResource.getName());
                }
                catch (IllegalArgumentException e) {
                    buf.append("WARN: Cannot recognize type of ").append(clientlibElement.getPath()).append("\n");
                }
                if (type == null) continue;
                ClientlibResourceFolder resourceFolder = new ClientlibResourceFolder(type, clientlibElement);
                for (ClientlibRef ref : resourceFolder.getDependencies()) {
                    this.verifyRef(resourceFolder, ref, administrativeResolver, impersonationResolver, allCategories, buf);
                }
                for (ClientlibRef ref : resourceFolder.getEmbedded()) {
                    this.verifyRef(resourceFolder, ref, administrativeResolver, impersonationResolver, allCategories, buf);
                }
            }
        }
        catch (LoginException e) {
            buf.append("Cannot create anonymous or administrative resolver - ").append((Object)e);
            LOG.error("Cannot create anonymous or administrative resolver - " + (Object)((Object)e), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Error checking clientlibs", (Throwable)e);
        }
        finally {
            if (null != administrativeResolver) {
                administrativeResolver.close();
            }
            if (userResolver == null && null != impersonationResolver) {
                impersonationResolver.close();
            }
        }
        return buf.length() == 0 ? null : buf.toString();
    }

    @Override
    public void clearCache(ResourceResolver resolver) throws PersistenceException {
        LOG.info("Clear cache requested.");
        String cacheRootPath = this.clientlibConfig.getConfig().clientlibs_cache_root();
        Resource cacheRoot = Objects.requireNonNull(resolver.getResource(cacheRootPath));
        ArrayList<String> subpaths = new ArrayList<String>(Arrays.asList(resolver.getSearchPath()));
        subpaths.add(CATEGORYCACHE);
        for (String child : subpaths) {
            Resource childResource = cacheRoot.getChild(StringUtils.removeStart((String)child, (String)"/"));
            if (childResource == null) continue;
            if (StringUtils.countMatches((CharSequence)childResource.getPath(), (CharSequence)"/") < 3) {
                throw new IllegalArgumentException("Suspicious path for clientlib cache to delete: " + childResource.getPath());
            }
            LOG.info("Deleting {}", (Object)childResource.getPath());
            resolver.delete(childResource);
        }
    }

    protected List<String> removeChildren(List<String> unreachablePaths) {
        Collections.sort(unreachablePaths);
        ArrayList<String> result = new ArrayList<String>();
        for (String path : unreachablePaths) {
            if (this.isReachableFrom(result, path)) continue;
            result.add(path);
        }
        return result;
    }

    protected boolean isReachableFrom(List<String> paths, String path) {
        for (String ancestorPath : paths) {
            if (!this.isAncestorOrSelf(ancestorPath, path)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAncestorOrSelf(@Nullable String parentPath, @Nullable String childPath) {
        return parentPath != null && childPath != null && (parentPath.equals(childPath) || childPath.startsWith(parentPath + "/"));
    }

    private void verifyRef(ClientlibResourceFolder resourceFolder, ClientlibRef ref, ResourceResolver administrativeResolver, ResourceResolver userResolver, Set<String> allCategories, StringBuilder buf) {
        if (ref.isExternalUri()) {
            return;
        }
        if (ref.isCategory()) {
            if (!allCategories.contains(ref.category)) {
                if (ref.optional) {
                    buf.append("INFO: empty optional category ").append(ref).append(" referenced\n");
                } else {
                    buf.append("WARN: empty mandatory category ").append(ref).append(" referenced\n");
                }
            }
            return;
        }
        Resource resourceAsAdmin = this.retrieveResource(ref.path, administrativeResolver);
        if (resourceAsAdmin != null) {
            Resource resourceAsUser = this.retrieveResource(ref.path, userResolver);
            if (resourceAsUser == null) {
                buf.append("ERROR: unreadable reference ").append(resourceAsAdmin.getPath()).append(" of readable client library resource folder ").append(resourceFolder.resource.getPath()).append("\n");
            } else if (!resourceAsAdmin.getPath().equals(resourceAsUser.getPath())) {
                buf.append("ERROR: Permission problem: resource different for admin and anonymous for ").append(ref.toString()).append(" : ").append(resourceAsAdmin.getPath()).append(" vs. ").append(resourceAsUser.getPath()).append("\n");
            } else if (new FileHandle(resourceAsAdmin).isValid() && !new FileHandle(resourceAsUser).isValid()) {
                buf.append("ERROR: Content resource not readable: ").append(resourceAsAdmin.getPath()).append("\n");
            }
        } else if (!resourceFolder.getOptional()) {
            buf.append("ERROR: can't find element ").append(ref.path).append(" of resource folder ").append(resourceFolder.resource.getPath()).append("\n");
        }
    }

    static {
        CRUD_CACHE_FOLDER_PROPS.put("jcr:primaryType", "sling:Folder");
        LOG = LoggerFactory.getLogger(DefaultClientlibService.class);
        orderResourceComparator = (o1, o2) -> {
            int order2;
            int order1 = ResourceHandle.use(o1).getProperty("order", 0);
            int res = Integer.compare(order1, order2 = ResourceHandle.use(o2).getProperty("order", 0).intValue());
            return res != 0 ? res : o1.getPath().compareTo(o2.getPath());
        };
    }
}

