/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Composum Nodes PostServlet Blocker"})
@Designate(ocd=Configuration.class)
public class DenyPostServiceImpl
implements SlingPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DenyPostServiceImpl.class);
    @Nonnull
    protected volatile List<Pattern> deniedPathList = Collections.emptyList();

    public void process(SlingHttpServletRequest request, List<Modification> changes) throws ResourceNotFoundException {
        if (!this.deniedPathList.isEmpty()) {
            Resource resource = request.getResource();
            String path = resource.getPath();
            for (Pattern pat : this.deniedPathList) {
                if (!pat.matcher(path).matches()) continue;
                LOG.warn("POST to {} reached default SlingPostServlet, but is forbidden via pattern {}", (Object)path, (Object)pat.pattern());
                throw new IllegalArgumentException("POSTing to resource via default SlingPostServlet forbidden at this JCR path");
            }
        }
    }

    @Activate
    @Modified
    protected void activate(Configuration configuration) {
        String[] deniedpaths = configuration.deniedpaths();
        ArrayList<Pattern> newpaths = new ArrayList<Pattern>();
        if (deniedpaths != null) {
            for (String patternString : deniedpaths) {
                try {
                    Pattern pattern = Pattern.compile(patternString);
                    newpaths.add(pattern);
                }
                catch (PatternSyntaxException pe) {
                    LOG.error("Pattern not parseable: {}", (Object)patternString, (Object)pe);
                }
            }
        }
        this.deniedPathList = newpaths;
    }

    @Deactivate
    protected void deactivate() {
        this.deniedPathList = Collections.emptyList();
    }

    @ObjectClassDefinition(name="Composum PostServlet Blocker", description="A service that blocks the default SlingPostServlet for configurable paths, since that sometimes creates unwanted resources when deploying and the corresponding servlet is not present.")
    public static @interface Configuration {
        @AttributeDefinition(name="Denied Paths", description="Regular expressions the request path is compared to. If one of these matches the whole path, the operations called on the SlingPostServlet are rolled back.")
        public String[] deniedpaths() default {"/bin/.*"};
    }
}

