/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.clientlibs.servlet;

import com.composum.sling.clientlibs.handle.Clientlib;
import com.composum.sling.clientlibs.handle.ClientlibCategory;
import com.composum.sling.clientlibs.handle.ClientlibElement;
import com.composum.sling.clientlibs.handle.ClientlibExternalUri;
import com.composum.sling.clientlibs.handle.ClientlibFile;
import com.composum.sling.clientlibs.handle.ClientlibLink;
import com.composum.sling.clientlibs.handle.ClientlibRef;
import com.composum.sling.clientlibs.handle.ClientlibResourceFolder;
import com.composum.sling.clientlibs.handle.ClientlibVisitor;
import com.composum.sling.clientlibs.processor.AbstractClientlibVisitor;
import com.composum.sling.clientlibs.service.ClientlibService;
import com.composum.sling.core.util.XSS;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"service.description=Composum Nodes Clientlib Webconsole Plugin", "felix.webconsole.category=Composum", "felix.webconsole.label=clientlibs", "felix.webconsole.title=Composum Client Libraries", "felix.webconsole.css=clientlibs/slingconsole/composum/nodes/commons/clientlibplugin.css"})
public class ClientlibDebugConsolePlugin
extends HttpServlet {
    protected static final Pattern SELECTOR_REGEX = Pattern.compile(".*\\.([^.]+)\\.html");
    protected static final String REQUEST_PARAM_LIB = "lib";
    protected static final String REQUEST_PARAM_IMPERSONATE = "impersonate";
    protected static final String REQUEST_PARAM_TYPE = "type";
    protected static final String REQUEST_PARAM_CLEAR_CACHE = "clearCache";
    protected static final String LOC_CSS = "slingconsole/composum/nodes/commons/clientlibplugin.css";
    @Reference
    protected ClientlibService clientlibService;
    @Reference
    protected ResourceResolverFactory resolverFactory;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getRequestURI().endsWith(LOC_CSS)) {
            response.setContentType("text/css");
            try (InputStream cssSource = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/slingconsole/composum/nodes/commons/clientlibplugin.css");){
                IOUtils.copy((InputStream)Objects.requireNonNull(cssSource), (OutputStream)response.getOutputStream());
            }
            return;
        }
        String impersonation = XSS.filter(request.getParameter(REQUEST_PARAM_IMPERSONATE));
        PrintWriter writer = response.getWriter();
        Processor processor = new Processor(request, impersonation, writer);
        try {
            this.initResolvers(processor, impersonation);
            if (StringUtils.isNotBlank((CharSequence)XSS.filter(request.getParameter(REQUEST_PARAM_CLEAR_CACHE)))) {
                this.clientlibService.clearCache(processor.adminResolver);
                String location = request.getRequestURI() + "?" + request.getQueryString().replaceAll(REQUEST_PARAM_CLEAR_CACHE, "clearCacheDone");
                processor.adminResolver.commit();
                response.sendRedirect(location);
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)XSS.filter(request.getParameter("clearCacheDone")))) {
                writer.println("<br><br><br><h3>The complete clientlib cache was cleared.</h3><br>");
            }
            response.setContentType("text/html");
            writer.print("<html><body><h2>Structure of client libraries");
            if (StringUtils.isNotBlank((CharSequence)impersonation)) {
                writer.print(" as seen from " + processor.impersonationResolver.getUserID());
            }
            writer.println("</h2>");
            processor.requestedType = this.requestedClientlibType(request);
            if (processor.requestedType == null && null == XSS.filter(request.getParameter(REQUEST_PARAM_LIB))) {
                processor.printUsage();
            }
            processor.printForm();
            processor.printVerification();
            List<Clientlib.Type> printTypes = processor.requestedType == null ? Arrays.asList(Clientlib.Type.values()) : Collections.singletonList(processor.requestedType);
            Iterator<Clientlib.Type> iterator = printTypes.iterator();
            while (iterator.hasNext()) {
                Clientlib.Type type;
                processor.type = type = iterator.next();
                if (StringUtils.isBlank((CharSequence)XSS.filter(request.getParameter(REQUEST_PARAM_LIB)))) {
                    processor.printAllLibs();
                    continue;
                }
                for (String lib : XSS.filter(request.getParameterValues(REQUEST_PARAM_LIB))) {
                    ClientlibRef ref = lib.startsWith("category:") ? ClientlibRef.forCategory(type, lib.substring("category:".length()), false, null) : new ClientlibRef(type, lib, false, null);
                    processor.displayClientlibStructure(ref);
                }
            }
            writer.println("<hr/></body></html>");
        }
        finally {
            if (null != processor.adminResolver) {
                processor.adminResolver.close();
            }
            if (null != processor.impersonationResolver) {
                processor.impersonationResolver.close();
            }
            writer.close();
        }
    }

    protected void initResolvers(Processor processor, String impersonation) throws ServletException {
        try {
            processor.adminResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
        }
        catch (LoginException e) {
            processor.writer.println("Cannot get administrative resolver");
            throw new ServletException("Cannot get administrative resolver");
        }
        if (StringUtils.isBlank((CharSequence)impersonation)) {
            try {
                processor.impersonationResolver = this.resolverFactory.getResourceResolver(null);
            }
            catch (LoginException e) {
                processor.writer.println("Cannot get anonymous resolver");
                throw new ServletException("Cannot get anonymous resolver");
            }
        }
        try {
            HashMap<String, String> authenticationInfo = StringUtils.isNotBlank((CharSequence)impersonation) ? new HashMap<String, String>(Collections.singletonMap("user.impersonation", impersonation)) : null;
            processor.impersonationResolver = this.resolverFactory.getAdministrativeResourceResolver(authenticationInfo);
        }
        catch (LoginException e) {
            processor.writer.println("Could not login as " + impersonation);
            throw new ServletException("Could not login as " + impersonation);
        }
    }

    protected Clientlib.Type requestedClientlibType(HttpServletRequest request) {
        String typeParameter;
        Clientlib.Type type = null;
        String uri = request.getRequestURI();
        Matcher matcher = SELECTOR_REGEX.matcher(uri);
        if (matcher.matches()) {
            type = Clientlib.Type.valueOf(matcher.group(1));
        }
        if (StringUtils.isNotBlank((CharSequence)(typeParameter = XSS.filter(request.getParameter(REQUEST_PARAM_TYPE))))) {
            type = "all".equalsIgnoreCase(typeParameter) ? null : Clientlib.Type.valueOf(typeParameter);
        }
        return type;
    }

    protected class DebugVisitor
    extends AbstractClientlibVisitor {
        protected static final int INDENTAMOUNT = 8;
        protected int indentation;
        protected final PrintWriter writer;

        protected DebugVisitor(ClientlibElement owner, ClientlibService service, ResourceResolver resolver, PrintWriter writer) {
            super(owner, service, resolver, new LinkedHashSet<ClientlibLink>());
            this.writer = writer;
        }

        @Override
        protected ClientlibVisitor createVisitorFor(ClientlibElement element) {
            return this;
        }

        @Override
        protected boolean isNotProcessed(ClientlibRef ref) {
            return true;
        }

        @Override
        protected void markAsProcessed(ClientlibLink link, ClientlibResourceFolder parent, ClientlibVisitor.VisitorMode visitorMode) {
        }

        @Override
        protected void notPresent(ClientlibRef ref, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder folder) {
            this.writer.println(StringUtils.repeat((String)" ", (int)(8 * this.indentation)) + this.modeName(mode) + " NOT PRESENT: " + (ref.optional ? "optional " : "mandatory ") + ref);
        }

        @Nonnull
        private String modeName(ClientlibVisitor.VisitorMode mode) {
            return ClientlibVisitor.VisitorMode.EMBEDDED.equals((Object)mode) ? " embeds " : " depends";
        }

        @Override
        public void visit(ClientlibCategory category, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) throws IOException, RepositoryException {
            this.writer.println(StringUtils.repeat((String)" ", (int)(8 * this.indentation)) + this.modeName(mode) + " " + category);
            ++this.indentation;
            super.visit(category, mode, parent);
            --this.indentation;
        }

        @Override
        public void visit(Clientlib clientlib, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) throws IOException, RepositoryException {
            String order = 0 != clientlib.getOrder() ? " [order=" + clientlib.getOrder() + "]" : "";
            this.writer.println(StringUtils.repeat((String)" ", (int)(8 * this.indentation)) + this.modeName(mode) + " " + clientlib + order);
            ++this.indentation;
            super.visit(clientlib, mode, parent);
            --this.indentation;
        }

        @Override
        public void visit(ClientlibResourceFolder folder, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) throws IOException, RepositoryException {
            this.writer.println(StringUtils.repeat((String)" ", (int)(8 * this.indentation)) + this.modeName(mode) + " " + folder + (folder.getOptional() ? "[Opt]" : ""));
            ++this.indentation;
            super.visit(folder, mode, parent);
            --this.indentation;
        }

        @Override
        public void visit(ClientlibFile file, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) throws RepositoryException, IOException {
            this.writer.println(StringUtils.repeat((String)" ", (int)(8 * this.indentation)) + this.modeName(mode) + " " + file);
            ++this.indentation;
            super.visit(file, mode, parent);
            --this.indentation;
        }

        @Override
        public void visit(ClientlibExternalUri externalUri, ClientlibVisitor.VisitorMode mode, ClientlibResourceFolder parent) {
            this.writer.println(StringUtils.repeat((String)" ", (int)(8 * this.indentation)) + this.modeName(mode) + " " + externalUri);
            ++this.indentation;
            super.visit(externalUri, mode, parent);
            --this.indentation;
        }
    }

    protected class Processor {
        Clientlib.Type requestedType;
        Clientlib.Type type;
        HttpServletRequest request;
        PrintWriter writer;
        ResourceResolver adminResolver;
        ResourceResolver impersonationResolver;
        String impersonation;
        String impersonationParam;

        public Processor(HttpServletRequest request, String impersonation, PrintWriter writer) {
            this.request = request;
            this.impersonation = impersonation;
            this.impersonationParam = StringUtils.isNotBlank((CharSequence)impersonation) ? "&impersonate=" + impersonation.trim() : "";
            this.writer = writer;
        }

        protected void printUsage() {
            String url = this.request.getRequestURL().toString().replaceAll("\\.[^/]+$", "") + ".css.html";
            this.writer.println("<h3>Usage:</h3>");
            this.writer.println("Please give the type of the client library as selector and one or more");
            this.writer.println("client libraries or -categories as parameter lib. Some examples:<ul>");
            this.printLinkItem(url + "?lib=category:composum.nodes.console.browser");
            this.printLinkItem(url + "?lib=/libs/composum/nodes/console/clientlibs/base");
            this.printLinkItem(url + "?lib=composum/nodes/console/clientlibs/base");
            this.writer.println("</ul>This prints the files and other included client libraries.");
            this.writer.println("It does not check for duplicated elements, as the normal rendering process does.</p>");
            this.writer.println("This prints all libraries of the type given as selector, no selector prints all:<ul>");
            this.printLinkItem(url);
            this.writer.println("</ul>");
            this.writer.flush();
        }

        protected void printLinkItem(String url) {
            this.writer.println("<li><a href=\"" + url + this.impersonationParam + "\">" + url + "</a></li>");
        }

        protected void printForm() {
            this.writer.println("<form action=\"" + this.request.getRequestURL() + "\" method=\"get\">");
            this.writer.println("Type: <select name=\"type\"> <option value=\"all\">All</option>");
            for (Clientlib.Type selectType : Clientlib.Type.values()) {
                this.writer.print("        <option value=\"" + selectType.name() + "\"");
                if (selectType == this.requestedType) {
                    this.writer.print(" selected ");
                }
                this.writer.print(">" + selectType.name());
                this.writer.println("</option>");
            }
            this.writer.println("</select>");
            this.writer.print(" Library: <input type=\"text\" name=\"lib\" value=\"");
            String lib = this.request.getParameter(ClientlibDebugConsolePlugin.REQUEST_PARAM_LIB);
            if (lib != null) {
                this.writer.print(lib);
            }
            this.writer.println("\">\n");
            this.writer.print(" Impersonate:\n <input type=\"text\" name=\"impersonate\" value=\"");
            String impersonate = this.request.getParameter(ClientlibDebugConsolePlugin.REQUEST_PARAM_IMPERSONATE);
            if (StringUtils.isNotBlank((CharSequence)impersonate)) {
                this.writer.print(impersonate);
            }
            this.writer.println("\">");
            this.writer.println("<input type=\"submit\" value=\"Submit\">\n");
            this.writer.println("<br><br><input type=\"submit\" title=\"This shouldn't normally be neccesary - use with caution - all used client libraries have to be rendered again.\" name=\"clearCache\" value=\"Clear the whole Clientlib Cache\">\n");
            this.writer.println("</form>\n");
        }

        protected void printVerification() {
            String verificationResults = ClientlibDebugConsolePlugin.this.clientlibService.verifyClientlibPermissions(this.type, this.impersonationResolver, false);
            if (StringUtils.isNotBlank((CharSequence)verificationResults)) {
                this.writer.println("<hr/><h3>Permission information / errors for " + (String)StringUtils.defaultIfBlank((CharSequence)this.impersonation, (CharSequence)"anonymous") + ":</h3><pre>");
                this.writer.println(verificationResults);
                this.writer.println("</pre>");
            }
        }

        protected void printAllLibs() throws ServletException, IOException {
            try {
                QueryManager querymanager = ((Session)Objects.requireNonNull(this.adminResolver.adaptTo(Session.class))).getWorkspace().getQueryManager();
                String statement = "//element(*)[sling:resourceType='composum/nodes/commons/clientlib']/" + this.type.name() + "/..  order by path";
                List clientlibs = IteratorUtils.toList((Iterator)this.adminResolver.findResources(statement, "xpath"));
                for (Resource clientlibResource : clientlibs) {
                    if (this.impersonationResolver.getResource(clientlibResource.getPath()) == null) continue;
                    this.displayClientlibStructure(new Clientlib(this.type, clientlibResource).getRef());
                }
            }
            catch (RepositoryException e) {
                throw new ServletException((Throwable)e);
            }
        }

        protected void displayClientlibStructure(ClientlibRef ref) throws IOException, ServletException {
            ClientlibElement clientlib = ClientlibDebugConsolePlugin.this.clientlibService.resolve(ref, this.adminResolver);
            String normalizedPath = this.normalizePath(ref, clientlib);
            StringBuilder categories = new StringBuilder();
            String requestUrl = this.request.getRequestURL().toString();
            String url = requestUrl.replaceAll("\\.[^/]+$", "") + "." + ref.type.name() + ".html";
            if (clientlib instanceof Clientlib) {
                Clientlib thelib = (Clientlib)clientlib;
                if (thelib.getCategories().isEmpty()) {
                    categories.append(" (no categories)");
                } else {
                    categories.append(" (in categories ");
                    boolean first = true;
                    for (String cat : thelib.getCategories()) {
                        if (!first) {
                            categories.append(", ");
                        }
                        first = false;
                        categories.append("<a href=\"").append(url).append("?lib=category:").append(cat).append(this.impersonationParam).append("\">").append(cat).append("</a>");
                    }
                    categories.append(")");
                }
            }
            Validate.notNull((Object)clientlib, (String)("Not found: " + ref), (Object[])new Object[0]);
            this.writer.println("<hr/>");
            this.writer.println("<h3>Structure of <a href=\"" + url + "?lib=" + normalizedPath + this.impersonationParam + "\">" + ref + "</a>" + categories + "</h3>");
            this.writer.println("<code>&lt;cpn:clientlib type=\"" + ref.type.name() + "\" path=\"" + normalizedPath + "\"/&gt;</code><br/><hr/><pre>");
            try {
                new DebugVisitor(clientlib, ClientlibDebugConsolePlugin.this.clientlibService, this.adminResolver, this.writer).execute();
            }
            catch (RepositoryException e) {
                throw new ServletException((Throwable)e);
            }
            this.writer.println("</pre>");
        }

        protected String normalizePath(ClientlibRef ref, ClientlibElement clientlib) {
            if (ref.isCategory()) {
                return "category:" + ref.category;
            }
            if (!ref.path.startsWith("/")) {
                return ref.path;
            }
            for (String pathelement : this.adminResolver.getSearchPath()) {
                String normalizedPath;
                ClientlibElement lib2;
                if (!ref.path.startsWith(pathelement) || !((lib2 = ClientlibDebugConsolePlugin.this.clientlibService.resolve(new ClientlibRef(ref.type, normalizedPath = ref.path.substring(pathelement.length()), ref.optional, ref.properties), this.adminResolver)) instanceof Clientlib)) continue;
                Clientlib reresolvedLib = (Clientlib)lib2;
                if (!reresolvedLib.getRef().path.equals(clientlib.getRef().path)) continue;
                return normalizedPath;
            }
            return ref.path;
        }
    }
}

